/*
 * Decompiled with CFR 0.152.
 */
package com.tool.classfile;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class SourceWriter
extends OutputStream {
    private boolean newline = true;
    private int linenumber = 1;
    private OutputStream out;
    File sourceFile = null;
    SourceWriter parent = null;
    private static final byte[] space = new byte[]{32, 32, 32, 32};

    public SourceWriter() {
        this((OutputStream)null);
    }

    public SourceWriter(String filename) throws IOException {
        this(new File(filename));
    }

    public SourceWriter(File file) throws IOException {
        this(new FileOutputStream(file));
        this.sourceFile = file;
    }

    public SourceWriter(OutputStream _out) {
        this(_out, 1);
    }

    public SourceWriter(OutputStream _out, int startLine) {
        this.out = _out == null ? null : new BufferedOutputStream(_out);
        this.linenumber = startLine;
    }

    public SourceWriter(SourceWriter _parent) {
        this.out = _parent.out;
        this.parent = _parent;
    }

    public File getSourceFile() {
        if (this.parent != null) {
            return this.parent.getSourceFile();
        }
        return this.sourceFile;
    }

    public int line_number() {
        if (this.parent != null) {
            return this.parent.line_number();
        }
        return this.linenumber;
    }

    public String line_name() {
        return this.line_name(this.line_number());
    }

    public String line_name(int line) {
        File f = this.getSourceFile();
        if (f == null) {
            return "line#" + line;
        }
        return f.getName() + "(" + line + "):";
    }

    private void newLine() throws IOException {
        this.newline = true;
        if (this.parent != null) {
            this.parent.newLine();
        } else {
            if (this.out != null) {
                this.out.flush();
            }
            ++this.linenumber;
        }
    }

    private void linespace() throws IOException {
        if (this.parent != null) {
            if (this.out != null) {
                this.newline = false;
                this.out.write(space);
            }
            this.parent.linespace();
        }
    }

    public void write(int b) throws IOException {
        if (b != 10 && this.newline) {
            this.linespace();
        }
        if (this.out != null) {
            this.out.write(b);
        }
        if (b == 10) {
            this.newLine();
        }
    }

    public void flush() throws IOException {
        if (this.out != null) {
            this.out.flush();
        }
    }

    public void close() throws IOException {
        this.flush();
        if (this.out != null && this.parent != null) {
            this.out.close();
        }
    }

    public void writeString(String s) throws IOException {
        this.write(s.getBytes());
    }

    public void writeLine() throws IOException {
        this.writeLine(null);
    }

    public void writeLine(String line) throws IOException {
        if (line != null) {
            this.writeString(line);
        }
        this.writeString("\r\n");
    }
}

