/*
 * Decompiled with CFR 0.152.
 */
package com.tool.classfile.pcodes;

import com.tool.classfile.CodeException;
import com.tool.classfile.Context;
import com.tool.classfile.opc;
import com.tool.classfile.pcodes.Instruction;
import com.tool.classfile.pcodes.InstructionWriter;
import com.tool.classfile.sc;

public abstract class Instruction_class
extends Instruction {
    public final String className;
    public final int dims;

    protected Instruction_class(int op_code, String _className, int _dims) {
        super(op_code);
        this.className = sc.className(_className);
        this.dims = _dims;
    }

    protected Instruction_class(int op_code, String _className) {
        this(op_code, _className, 0);
    }

    public int length() {
        if (this.op_code == 188 && sc.isPrimitive(this.className)) {
            return 2;
        }
        if (this.op_code == 197) {
            return 4;
        }
        return 3;
    }

    public String toString() {
        String s = opc.opc_names[this.op_code] + " " + sc.javaType(this.className);
        if (this.op_code == 197) {
            s = s + " " + this.dims;
        }
        return s;
    }

    protected void finalWrite(InstructionWriter out) {
        if (this.op_code == 188 && sc.isPrimitive(this.className)) {
            out.writeu1(this.op_code);
            if (sc.isBoolean(this.className)) {
                out.writeu1(4);
            } else if (sc.isByte(this.className)) {
                out.writeu1(8);
            } else if (sc.isChar(this.className)) {
                out.writeu1(5);
            } else if (sc.isShort(this.className)) {
                out.writeu1(9);
            } else if (sc.isInteger(this.className)) {
                out.writeu1(10);
            } else if (sc.isLong(this.className)) {
                out.writeu1(11);
            } else if (sc.isFloat(this.className)) {
                out.writeu1(6);
            } else if (sc.isDouble(this.className)) {
                out.writeu1(7);
            } else {
                CodeException.assertThat(false, "Unknown type '" + this.className + "'");
            }
        } else {
            if (this.op_code == 188) {
                out.writeu1(189);
            } else {
                out.writeu1(this.op_code);
            }
            int index = Context.getConstantPool().getClass(this.className);
            out.writeu2(index);
            if (this.op_code == 197) {
                out.writeu1(this.dims);
            }
        }
    }
}

