/*
 * Decompiled with CFR 0.152.
 */
package com.tool.classfile.pcodes;

import com.tool.classfile.CodeException;
import com.tool.classfile.Const;
import com.tool.classfile.Context;
import com.tool.classfile.pcodes.Instruction;
import com.tool.classfile.pcodes.InstructionWriter;
import com.tool.classfile.pcodes.OperandStack;
import com.tool.classfile.sc;

public class Instruction_const
extends Instruction {
    public final Const value;

    public Instruction_const(Const _value) {
        super(0);
        this.value = _value;
        if (this.value == null) {
            this.op_code = 1;
        } else {
            String type = sc.pcodeType(_value.type);
            if (sc.isInteger(type)) {
                int v = this.value.intValue();
                this.op_code = v >= -1 && v <= 5 ? 3 + v : (v >= -128 && v <= 127 ? 16 : (v >= Short.MIN_VALUE && v <= Short.MAX_VALUE ? 17 : 18));
            } else if (sc.isLong(type)) {
                long v = this.value.longValue();
                this.op_code = v == 0L ? 9 : (v == 1L ? 10 : 20);
            } else if (sc.isFloat(type)) {
                float v = this.value.floatValue();
                this.op_code = v == 0.0f ? 11 : (v == 1.0f ? 12 : (v == 2.0f ? 13 : 18));
            } else if (sc.isDouble(type)) {
                double v = this.value.doubleValue();
                this.op_code = v == 0.0 ? 14 : (v == 1.0 ? 15 : 20);
            } else if (sc.isString(type)) {
                String v = this.value.stringValue();
                this.op_code = v == null ? 1 : 18;
            } else {
                CodeException.assertThat(false);
            }
        }
    }

    public int length() {
        if (this.op_code == 20) {
            return 3;
        }
        if (this.op_code == 16) {
            return 2;
        }
        if (this.op_code == 17) {
            return 3;
        }
        if (this.op_code == 18 || this.op_code == 19) {
            int index = Context.getConstantPool().get(this.value);
            if (index < 256) {
                return 2;
            }
            return 3;
        }
        return 1;
    }

    protected void finalWrite(InstructionWriter out) {
        if (this.op_code == 16) {
            out.writeu1(16);
            out.writeu1(this.value.intValue());
        } else if (this.op_code == 17) {
            out.writeu1(17);
            out.writeu2(this.value.intValue());
        } else if (this.op_code == 20) {
            int index = Context.getConstantPool().get(this.value);
            out.writeu1(20);
            out.writeu2(index);
        } else if (this.op_code == 18 || this.op_code == 19) {
            int index = Context.getConstantPool().get(this.value);
            if (index < 256) {
                out.writeu1(18);
                out.writeu1(index);
            } else {
                out.writeu1(19);
                out.writeu2(index);
            }
        } else {
            out.writeu1(this.op_code);
        }
    }

    public String toString() {
        if (this.value == null) {
            return "const null";
        }
        return "const " + sc.javaType(this.value.type) + " " + this.value.toString();
    }

    public void checkStack(OperandStack stack) throws CodeException {
        if (this.value == null) {
            stack.push("Ljava/lang/Object;");
        } else {
            stack.push(this.value.type);
        }
    }
}

