/*
 * Decompiled with CFR 0.152.
 */
package com.tool.simplecode;

import com.tool.classfile.MethodRef;
import com.tool.classfile.sc;
import com.tool.simplecode.BuildEnv;
import com.tool.simplecode.Unit;
import java.io.IOException;

public abstract class Invoke
extends Unit {
    Unit object;
    MethodRef method;
    int op_code;
    Unit[] args;

    protected Invoke(int _op_code, Unit _object, MethodRef _method, Unit[] _args) {
        super(Invoke.getLevel(_method));
        this.op_code = _op_code;
        this.object = Unit.toUnit(_object);
        this.method = _method;
        this.args = Unit.toUnit(_args);
    }

    private static int getLevel(MethodRef ref) {
        if (sc.isVoid(ref.type)) {
            return -1;
        }
        return 1;
    }

    protected String genCodes(BuildEnv env, String requiredType) throws IOException {
        this.object.buildCodes(env, "Ljava/lang/Object;");
        if (this.args != null) {
            int i = 0;
            while (i < this.args.length) {
                this.args[i].buildCodes(env, this.method.parameterTypes[i]);
                ++i;
            }
        }
        env.current_block._invoke(this.op_code, this.method);
        return this.method.type;
    }

    protected void genSource(BuildEnv env) throws IOException {
        boolean bsuper = false;
        if (this.op_code == 183 && !this.method.className.equals(env.cls.className)) {
            bsuper = true;
        }
        if (bsuper) {
            env.out.writeString("super");
        } else {
            this.object.buildSource(env, 1);
        }
        if (!bsuper || !this.method.name.equals("<init>")) {
            env.out.writeString("." + this.method.name);
        }
        env.out.writeString("(");
        int i = 0;
        while (i < this.args.length) {
            if (i > 0) {
                env.out.writeString(", ");
            }
            this.args[i].buildSource(env, 99);
            ++i;
        }
        env.out.writeString(")");
    }
}

