/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.event;

import com.kingdee.util.IPUtils;
import java.net.InetAddress;
import java.net.SocketException;
import org.apache.log4j.Logger;

public final class SystemEntironment {
    private static final Logger logger = Logger.getLogger(SystemEntironment.class);
    private String hostName;
    private String hostIP;

    private SystemEntironment() {
        try {
            InetAddress address = IPUtils.getLocleAddress();
            this.hostName = address.getHostName();
            this.hostIP = address.getHostAddress();
        }
        catch (SocketException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            this.hostName = "localhost";
            this.hostIP = "127.0.0.1";
        }
    }

    public static SystemEntironment getInstance() {
        return SystemEntironmentHolder.entironment;
    }

    public String getHostIP() {
        return this.hostIP;
    }

    public String getHostName() {
        return this.hostName;
    }

    private static class SystemEntironmentHolder {
        static SystemEntironment entironment = new SystemEntironment();

        private SystemEntironmentHolder() {
        }
    }
}

