/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.event.adapter;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.event.adapter.BOSEntityMappingInfo;
import com.kingdee.bos.event.adapter.BOSEventUtils;
import com.kingdee.bos.event.adapter.BOSParameterMappingInfo;
import com.kingdee.bos.event.adapter.DefaultWFSubscribePointUtil;
import com.kingdee.bos.event.adapter.EventMappingInfo;
import com.kingdee.bos.event.adapter.IEventDefineService;
import com.kingdee.bos.event.adapter.SourceEventInfo;
import com.kingdee.bos.event.adapter.SourceFormalParameterInfo;
import com.kingdee.bos.event.exception.EventRepositoryException;
import com.kingdee.bos.event.model.EventRepositoryServiceFactory;
import com.kingdee.bos.event.model.IEventRepositoryService;
import com.kingdee.bos.event.model.cem.CEMFactory;
import com.kingdee.bos.event.model.cem.CommonEvent;
import com.kingdee.bos.event.model.cem.ExtendedData;
import com.kingdee.bos.event.model.es.EventSubscribePoint;
import com.kingdee.bos.event.model.es.EventSubscribePointRelation;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class DyanmicBillEventDefineService2
implements IEventDefineService {
    IEventRepositoryService service = EventRepositoryServiceFactory.getVMEventRepositoryService();

    @Override
    public void saveEventDef(SourceEventInfo eventInfo, String eventProducer, String eventMapingRule) throws EventRepositoryException {
        CommonEvent ce = this.generateCEMFromSourceEventInfo(eventInfo);
        this.service.saveCommonEvent(ce);
        EventMappingInfo eventMappingInfo = this.generateEventMappingInfo(ce, eventInfo, eventProducer, eventMapingRule);
        this.service.saveEventMappingInfo(eventMappingInfo);
        EventSubscribePoint esp = DefaultWFSubscribePointUtil.getDefaultWfSubscribePoint();
        EventSubscribePointRelation espr = DefaultWFSubscribePointUtil.getDefaultWfSubscribePointRelationTemplate();
        espr.setRefEventId(ce.getId());
        espr.setRefEventName(ce.getName());
        espr.setRefEventType(ce.getType());
        espr.setRefEventGroup(ce.getGroup());
        this.service.subscribeEvent(esp, espr, true);
    }

    private EventMappingInfo generateEventMappingInfo(CommonEvent ce, SourceEventInfo eventInfo, String eventProducer, String eventMapingRule) {
        EventMappingInfo eventMappingInfo = new EventMappingInfo();
        eventMappingInfo.setName(ce.getName());
        eventMappingInfo.setMappingRule(eventMapingRule);
        eventMappingInfo.setProducer(eventProducer);
        BOSEntityMappingInfo bemInfo = new BOSEntityMappingInfo();
        bemInfo.setBosType(eventInfo.getBosType());
        bemInfo.setEntityName(eventInfo.getEntityName());
        bemInfo.setMethodName(eventInfo.getOperationName());
        bemInfo.setMethodPk("");
        bemInfo.setEntityDescription(eventInfo.getDescription());
        List sourceFormalParameterList = eventInfo.getSrourceFormalParameterInfos();
        if (sourceFormalParameterList != null) {
            ArrayList<BOSParameterMappingInfo> bpmInfos = new ArrayList<BOSParameterMappingInfo>();
            for (SourceFormalParameterInfo info : sourceFormalParameterList) {
                BOSParameterMappingInfo bpmInfo = new BOSParameterMappingInfo();
                bpmInfo.setFormalParameterName(info.getFormalParameterName());
                bpmInfo.setActualParameterIndex(info.getActualParameterIndex());
                bpmInfo.setBOPK(info.isPK());
                bpmInfo.setDescription(info.getDescription());
                bpmInfos.add(bpmInfo);
            }
            bemInfo.setParameterMappings(bpmInfos);
        }
        ArrayList<BOSEntityMappingInfo> eventMappingInfos = new ArrayList<BOSEntityMappingInfo>();
        eventMappingInfos.add(bemInfo);
        eventMappingInfo.setEventMappingInfos(eventMappingInfos);
        return eventMappingInfo;
    }

    private String generateEventName(SourceEventInfo eventInfo) {
        return eventInfo.getEntityName() + "." + eventInfo.getOperationName();
    }

    private CommonEvent generateCEMFromSourceEventInfo(SourceEventInfo eventInfo) {
        List fpList;
        CommonEvent event = CEMFactory.eINSTANCE.createCommonEvent();
        if (StringUtils.isEmpty((String)event.getId())) {
            event.setId(BOSUuid.create((String)"COMMNEVT").toString());
        }
        String eventName = this.generateEventName(eventInfo);
        event.setName(eventName);
        event.setAlias(eventInfo.getEventAlias());
        event.setDescription(eventInfo.getDescription());
        Properties props = eventInfo.getExtensionProperties();
        event.setVersion(props.getProperty("Version", "1.0"));
        event.setGroup(props.getProperty("Group", "BOSEvent"));
        event.setType(props.getProperty("Type", "DyanmicFormGen"));
        event.setExpirationDate(props.getProperty("ExpirationDate", BOSEventUtils.generateDefaultExpiredDate()));
        event.setPriority(String.valueOf(50));
        event.setSeverity(String.valueOf(20));
        if (event.getExtendedDatas() == null) {
            event.setExtendedDatas(CEMFactory.eINSTANCE.createExtendedDatas());
        }
        if ((fpList = eventInfo.getSrourceFormalParameterInfos()) != null) {
            for (SourceFormalParameterInfo info : fpList) {
                if (info == null) continue;
                ExtendedData data = CEMFactory.eINSTANCE.createExtendedData();
                data.setName(info.getFormalParameterName());
                data.setDataType(info.getFormalParameterType());
                data.setMappingParameterName(info.getFormalParameterMappingName());
                data.setAlias(info.getFormalParameterNameAlias());
                data.setDescription(info.getDescription());
                event.getExtendedDatas().getExtendedData().add((Object)data);
            }
        }
        return event;
    }

    @Override
    public void deleteEventDef(String eventName, String eventMapingRule) throws EventRepositoryException {
        CommonEvent ce = this.service.getCommonEvent(eventName);
        EventSubscribePoint esp = DefaultWFSubscribePointUtil.getDefaultWfSubscribePoint();
        EventSubscribePointRelation espr = DefaultWFSubscribePointUtil.getDefaultWfSubscribePointRelationTemplate();
        espr.setRefEventId(ce.getId());
        espr.setRefEventName(ce.getName());
        espr.setRefEventType(ce.getType());
        espr.setRefEventGroup(ce.getGroup());
        this.service.deleteCommenEvent(eventName);
        this.service.deleteEventMappingInfo(eventName);
        this.service.unsubscribeEvent(esp, espr, true);
    }
}

