/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.event.core;

import com.kingdee.bos.event.ICommonEvent;
import com.kingdee.bos.event.core.EventServer;
import com.kingdee.bos.event.core.EventSubscriberRelationUtil;
import com.kingdee.bos.event.core.IEventDispatcher;
import com.kingdee.bos.event.exception.EventDispatchException;
import com.kingdee.bos.event.exception.EventRepositoryException;
import com.kingdee.bos.event.model.es.EventSubscribePoint;
import com.kingdee.bos.event.subscribe.DispatcherManager;
import com.kingdee.util.StringUtils;
import org.apache.log4j.Logger;

public class EventDispatcher
implements IEventDispatcher {
    Logger logger = Logger.getLogger(EventDispatcher.class);
    private EventServer server;
    private DispatcherManager manager;

    public EventDispatcher(EventServer server) {
        this.server = server;
        this.manager = server.getDispatcherManager();
    }

    @Override
    public void dispatchEvent(ICommonEvent event) throws EventDispatchException {
        if (event == null) {
            return;
        }
        try {
            EventSubscribePoint[] esps = this.getSubscriberFromEvent(event);
            this.manager.dispatchEventToSubQueues(event, esps);
            this.server.getEventQueue().commit(event);
        }
        catch (EventRepositoryException e) {
            this.logger.error((Object)"EventDispatcher.dispatchEvent error: ", (Throwable)((Object)e));
            this.server.getEventQueue().rollback(event);
            throw new EventDispatchException("EventDispatcher.dispatchEvent error:", (Throwable)((Object)e));
        }
    }

    @Override
    public EventSubscribePoint[] getSubscriberFromEvent(ICommonEvent event) throws EventRepositoryException {
        if (this.server == null || event == null || StringUtils.isEmpty((String)event.getName())) {
            throw new EventRepositoryException("EventDispatcher.getSubscriberFromEvent exception:");
        }
        EventSubscribePoint[] esps = EventSubscriberRelationUtil.getSubScriberFromEvent(this.server.getRepositoryService(), event, null, "async");
        return esps;
    }

    public EventServer getServer() {
        return this.server;
    }
}

