/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.event.core;

import com.kingdee.bos.event.ICommonEvent;
import com.kingdee.bos.event.exception.EventRepositoryException;
import com.kingdee.bos.event.model.IEventRepositoryService;
import com.kingdee.bos.event.model.es.EventSubscribePoint;
import com.kingdee.bos.event.subscribe.EventSubscriberDefObj;
import com.kingdee.bos.event.subscribe.SubscribeInformantUtils;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;

public class EventSubscriberRelationUtil {
    public static EventSubscribePoint[] getSubscriberFromEvent(IEventRepositoryService repositoryService, ICommonEvent event) throws EventRepositoryException {
        if (repositoryService == null || event == null || StringUtils.isEmpty((String)event.getName())) {
            throw new EventRepositoryException("EventDispatcher.getSubscriberFromEvent exception:");
        }
        EventSubscribePoint[] esps = repositoryService.getEventSubscribePointsByEventName(event.getName());
        return esps;
    }

    public static EventSubscribePoint[] getSubScriberFromEvent(IEventRepositoryService repositoryService, ICommonEvent event, String method, String processMode) throws EventRepositoryException {
        EventSubscribePoint[] esps = EventSubscriberRelationUtil.getSubscriberFromEvent(repositoryService, event);
        if (esps == null) {
            return null;
        }
        ArrayList<EventSubscribePoint> espList = new ArrayList<EventSubscribePoint>(esps.length);
        for (int i = 0; i < esps.length; ++i) {
            EventSubscriberDefObj dest;
            EventSubscribePoint esp = esps[i];
            if (esp == null || !EventSubscriberRelationUtil.isMatched(method, (dest = SubscribeInformantUtils.getEventSubscriberDefObj(esp.getDestination())).getMethod()) || !EventSubscriberRelationUtil.isMatched(processMode, dest.getProcessMode())) continue;
            espList.add(esp);
        }
        return espList.toArray(new EventSubscribePoint[espList.size()]);
    }

    private static boolean isMatched(String src, String target) {
        return src == null || src.trim().length() == 0 || src.trim().equalsIgnoreCase(target);
    }
}

