/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.event.core.queue;

import com.kingdee.bos.event.exception.InterruptedError;
import java.util.ArrayList;

public class Queue {
    private boolean immediateTimeOut = false;
    private QueueItem first;
    private QueueItem last;
    private int blocked;
    private static QueueItem freeItemChain;

    public synchronized void put(Object obj) {
        this.putInternal(obj, false);
    }

    public synchronized void put(Object obj, boolean isSilent) {
        this.putInternal(obj, isSilent);
    }

    private synchronized void putInternal(Object obj, boolean isSilent) {
        if (this.first == null) {
            this.first = this.last = Queue.createItem(obj);
        } else {
            this.last = this.last.next = Queue.createItem(obj);
        }
        if (this.blocked != 0 && !isSilent) {
            this.notify();
        }
    }

    public synchronized void setImmediateTimeOut(boolean immediateTimeOut) {
        this.immediateTimeOut = immediateTimeOut;
    }

    public synchronized Object get(long timeout) {
        if (this.first == null || this.blocked != 0) {
            if (timeout == 0L) {
                return null;
            }
            long startTime = System.currentTimeMillis();
            do {
                long currentTime;
                if ((currentTime = System.currentTimeMillis()) - startTime >= timeout || this.immediateTimeOut) {
                    return null;
                }
                try {
                    long rest = timeout - currentTime + startTime;
                    ++this.blocked;
                    this.wait(rest);
                    --this.blocked;
                }
                catch (InterruptedException e) {
                    this.notifyAll();
                    --this.blocked;
                    throw new InterruptedError();
                }
            } while (this.first == null);
        }
        QueueItem item = this.first;
        Object obj = item.obj;
        this.first = this.first.next;
        Queue.freeItem(item);
        if (this.blocked != 0 && this.first != null) {
            this.notifyAll();
        }
        return obj;
    }

    public synchronized Object get(Object obj) {
        QueueItem item = this.first;
        if (item != null) {
            if (item.obj == obj) {
                this.first = this.first.next;
                Queue.freeItem(item);
            } else {
                QueueItem preItem = item;
                item = item.next;
                while (item != null) {
                    if (item.obj == obj) {
                        preItem.next = item.next;
                        Queue.freeItem(item);
                        break;
                    }
                    preItem = item;
                    item = item.next;
                }
            }
        }
        if (this.blocked != 0 && this.first != null) {
            this.notifyAll();
        }
        return obj;
    }

    public synchronized Object get() {
        return this.get(Long.MAX_VALUE);
    }

    public boolean isEmpty() {
        return this.first == null;
    }

    public synchronized Object[] values() {
        if (this.first == null) {
            return new Object[0];
        }
        ArrayList<Object> allEntries = new ArrayList<Object>();
        QueueItem item = this.first;
        while (item != null) {
            allEntries.add(item.obj);
            item = item.next;
        }
        return allEntries.toArray();
    }

    private static final synchronized QueueItem createItem(Object obj) {
        QueueItem item;
        if (freeItemChain == null) {
            item = new QueueItem();
        } else {
            item = freeItemChain;
            freeItemChain = Queue.freeItemChain.next;
        }
        item.obj = obj;
        item.next = null;
        return item;
    }

    private static final synchronized void freeItem(QueueItem item) {
        item.next = freeItemChain;
        freeItemChain = item;
    }

    static class QueueItem {
        QueueItem next;
        Object obj;

        QueueItem() {
        }
    }
}

