/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.event.model;

import com.kingdee.bos.event.exception.EventRepositoryException;
import com.kingdee.bos.event.model.IResourceHandler;
import com.kingdee.bos.event.model.ResourceHandler;
import com.kingdee.bos.event.model.ResourceLocator;
import com.kingdee.bos.event.model.cem.CEMFactory;
import com.kingdee.bos.event.model.cem.CommonEvent;
import com.kingdee.bos.event.model.cem.DocumentRoot;
import com.kingdee.bos.event.model.es.ESFactory;
import com.kingdee.bos.event.model.es.EventSubscribePoint;
import com.kingdee.bos.event.model.es.EventSubscribePointRelation;
import com.kingdee.bos.event.model.es.EventSubscribePoints;
import com.kingdee.bos.event.model.es.EventSubscribers;
import com.kingdee.util.StringUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;

public final class EventResourceManager {
    Logger logger = Logger.getLogger(EventResourceManager.class);
    private Map eventModelCacheMap = null;
    private Map eventSubscriberCacheMap = null;
    private Map eventSubscriberRelationCacheMap = null;
    private Map eventName2IDMap = null;
    private Map eventSubscribePointName2IDMap = null;
    private IResourceHandler handler = null;
    private String[] uris;

    public EventResourceManager() {
        this.init();
    }

    private void init() {
        try {
            this.handler = new ResourceHandler();
            this.getAllEventModels();
            this.getEventSubscribePoints();
            this.getEventSubscriberRelations();
        }
        catch (EventRepositoryException e) {
            this.logger.error((Object)"init EventResourceManager error:", (Throwable)((Object)e));
        }
    }

    public Map getEventName2IDMap() {
        return this.eventName2IDMap;
    }

    public Map getEventSubscribePointName2IDMap() {
        return this.eventSubscribePointName2IDMap;
    }

    public Map getAllEventModels() throws EventRepositoryException {
        if (this.eventModelCacheMap == null || this.eventModelCacheMap.size() <= 0) {
            this.eventName2IDMap = new HashMap();
            this.eventModelCacheMap = this.loadAllEventModels();
        }
        return this.eventModelCacheMap;
    }

    private Map loadAllEventModels() throws EventRepositoryException {
        HashMap<String, CommonEvent> eventMap = new HashMap<String, CommonEvent>();
        String[] uris = this.getResourceURIs();
        CommonEvent commonEvent = null;
        for (int i = 0; i < uris.length; ++i) {
            if (StringUtils.isEmpty((String)uris[i]) || !uris[i].endsWith(".cem") || (commonEvent = this.getCommonEvent(uris[i])) == null) continue;
            eventMap.put(commonEvent.getName(), commonEvent);
            this.eventName2IDMap.put(commonEvent.getName(), commonEvent.getId());
        }
        return eventMap;
    }

    private CommonEvent getCommonEvent(String uri) {
        if (StringUtils.isEmpty((String)uri)) {
            return null;
        }
        Resource resource = this.handler.loadResource(URI.createURI((String)uri));
        DocumentRoot doc = (DocumentRoot)resource.getContents().get(0);
        return doc.getCommonEvent();
    }

    public Map getEventSubscribePoints() throws EventRepositoryException {
        if (this.eventSubscriberCacheMap == null || this.eventSubscriberCacheMap.size() <= 0) {
            this.eventSubscribePointName2IDMap = new HashMap();
            this.eventSubscriberCacheMap = this.loadEventSubscribePoints();
        }
        return this.eventSubscriberCacheMap;
    }

    private Map loadEventSubscribePoints() throws EventRepositoryException {
        HashMap<String, EventSubscribePoint> eventMap = new HashMap<String, EventSubscribePoint>();
        String[] uris = this.getResourceURIs();
        EventSubscribers subscribers = null;
        for (int i = 0; i < uris.length; ++i) {
            if (StringUtils.isEmpty((String)uris[i]) || !uris[i].endsWith(".es") || (subscribers = this.getEventSubscribers(uris[i])) == null) continue;
            EList subscribePoints = subscribers.getEventSubscribePoints().getEventSubscribePoint();
            for (int j = 0; j < subscribePoints.size(); ++j) {
                EventSubscribePoint subscriber = (EventSubscribePoint)subscribePoints.get(j);
                if (subscriber == null) continue;
                eventMap.put(subscriber.getId(), subscriber);
                this.eventSubscribePointName2IDMap.put(subscriber.getName(), subscriber.getId());
            }
        }
        return eventMap;
    }

    EventSubscribers getEventSubscribers(String uri) {
        if (StringUtils.isEmpty((String)uri)) {
            return null;
        }
        Resource resource = this.handler.loadResource(URI.createURI((String)uri));
        com.kingdee.bos.event.model.es.DocumentRoot doc = null;
        if (resource == null || resource.getContents() == null || resource.getContents().size() < 1) {
            doc = ESFactory.eINSTANCE.createDocumentRoot();
            doc.setEventSubscribers(ESFactory.eINSTANCE.createEventSubscribers());
        } else {
            doc = (com.kingdee.bos.event.model.es.DocumentRoot)resource.getContents().get(0);
        }
        EventSubscribers esbs = doc.getEventSubscribers();
        if (esbs.getEventSubscribePoints() == null || esbs.getEventSubscribePoints().getEventSubscribePoint().size() < 1) {
            esbs.setEventSubscribePoints(ESFactory.eINSTANCE.createEventSubscribePoints());
        }
        if (esbs.getEventSubscribePointRelations() == null || esbs.getEventSubscribePointRelations().getEventSubscribePointRelation().size() < 1) {
            esbs.setEventSubscribePointRelations(ESFactory.eINSTANCE.createEventSubscribePointRelations());
        }
        return esbs;
    }

    EventSubscribers getEventSubscribers(URI uri) {
        Resource resource = this.handler.loadResource(uri);
        com.kingdee.bos.event.model.es.DocumentRoot doc = null;
        EventSubscribers esbs = null;
        if (resource == null || resource.getContents() == null) {
            doc = ESFactory.eINSTANCE.createDocumentRoot();
            doc.setEventSubscribers(ESFactory.eINSTANCE.createEventSubscribers());
            esbs = doc.getEventSubscribers();
        } else if (resource.getContents().get(0) instanceof com.kingdee.bos.event.model.es.DocumentRoot) {
            doc = (com.kingdee.bos.event.model.es.DocumentRoot)resource.getContents().get(0);
            esbs = doc.getEventSubscribers();
        }
        if (esbs.getEventSubscribePoints() == null) {
            esbs.setEventSubscribePoints(ESFactory.eINSTANCE.createEventSubscribePoints());
        }
        if (esbs.getEventSubscribePointRelations() == null) {
            esbs.setEventSubscribePointRelations(ESFactory.eINSTANCE.createEventSubscribePointRelations());
        }
        return esbs;
    }

    private String[] getResourceURIs() throws EventRepositoryException {
        if (this.uris == null || this.uris.length <= 0) {
            try {
                this.uris = ResourceLocator.getAllResourcesURI();
            }
            catch (IOException e) {
                throw new EventRepositoryException(e);
            }
        }
        return this.uris;
    }

    public Map getEventSubscriberRelations() throws EventRepositoryException {
        if (this.eventSubscriberRelationCacheMap == null || this.eventSubscriberRelationCacheMap.size() <= 0) {
            this.eventSubscriberRelationCacheMap = this.loadEventSubscriberRelations();
        }
        return this.eventSubscriberRelationCacheMap;
    }

    private Map loadEventSubscriberRelations() throws EventRepositoryException {
        HashMap<String, EventSubscribePointRelation> relationsMap = new HashMap<String, EventSubscribePointRelation>();
        String[] uris = this.getResourceURIs();
        EventSubscribers subscribers = null;
        for (int i = 0; i < uris.length; ++i) {
            if (StringUtils.isEmpty((String)uris[i]) || !uris[i].endsWith(".es") || (subscribers = this.getEventSubscribers(uris[i])) == null) continue;
            EList esprs = subscribers.getEventSubscribePointRelations().getEventSubscribePointRelation();
            for (int j = 0; j < esprs.size(); ++j) {
                EventSubscribePointRelation espr = (EventSubscribePointRelation)esprs.get(j);
                if (espr == null) continue;
                relationsMap.put(espr.getId(), espr);
            }
        }
        return relationsMap;
    }

    public void updateEventSubscribers(EventSubscribers ess, String uri) throws IOException, EventRepositoryException {
        Resource resource = this.handler.loadResource(URI.createURI((String)uri));
        com.kingdee.bos.event.model.es.DocumentRoot doc = null;
        if (resource == null || resource.getContents() == null) {
            doc = ESFactory.eINSTANCE.createDocumentRoot();
            doc.setEventSubscribers(ESFactory.eINSTANCE.createEventSubscribers());
        } else {
            doc = (com.kingdee.bos.event.model.es.DocumentRoot)resource.getContents().get(0);
        }
        doc.setEventSubscribers(ess);
        this.handler.saveResource(resource);
    }

    public void createEventSubscribers(EventSubscribePoint esp, String uri) throws IOException, EventRepositoryException {
        com.kingdee.bos.event.model.es.DocumentRoot doc = ESFactory.eINSTANCE.createDocumentRoot();
        EventSubscribers ess = ESFactory.eINSTANCE.createEventSubscribers();
        doc.setEventSubscribers(ess);
        EventSubscribePoints esps = ESFactory.eINSTANCE.createEventSubscribePoints();
        ess.setEventSubscribePoints(esps);
        esps.getEventSubscribePoint().add((Object)esp);
        this.handler.saveResource(URI.createURI((String)uri), doc);
    }

    public void updateEventDef(CommonEvent event, String uri) throws IOException, EventRepositoryException {
        Resource resource = this.handler.loadResource(URI.createURI((String)uri));
        DocumentRoot doc = null;
        if (resource == null || resource.getContents() == null) {
            doc = CEMFactory.eINSTANCE.createDocumentRoot();
            doc.setCommonEvent(CEMFactory.eINSTANCE.createCommonEvent());
        } else {
            doc = (DocumentRoot)resource.getContents().get(0);
        }
        doc.setCommonEvent(event);
        this.handler.saveResource(resource);
    }

    public void createEventDef(CommonEvent event, String uri) throws IOException, EventRepositoryException {
        DocumentRoot doc = CEMFactory.eINSTANCE.createDocumentRoot();
        doc.setCommonEvent(event);
        this.handler.saveResource(URI.createURI((String)uri), doc);
    }
}

