/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.event.producer;

import com.kingdee.bos.event.CommonEvent;
import com.kingdee.bos.event.EventDataType;
import com.kingdee.bos.event.EventExtendedData;
import com.kingdee.bos.event.EventPriority;
import com.kingdee.bos.event.EventSeverity;
import com.kingdee.bos.event.ICommonEvent;
import com.kingdee.bos.event.adapter.BOSEntityMappingInfo;
import com.kingdee.bos.event.adapter.BOSEventUtils;
import com.kingdee.bos.event.adapter.BOSParameterMappingInfo;
import com.kingdee.bos.event.adapter.EventMappingInfo;
import com.kingdee.bos.event.exception.CommonEventException;
import com.kingdee.bos.event.exception.EventValidationException;
import com.kingdee.bos.event.model.cem.ExtendedData;
import com.kingdee.bos.event.producer.IEventProducer;
import com.kingdee.bos.event.util.Utilities;
import com.kingdee.bos.framework.agent.IObjectValueAgent;
import com.kingdee.bos.service.IServiceContext;
import com.kingdee.bos.service.ServiceContext;
import com.kingdee.util.StringUtils;
import java.text.ParseException;
import java.util.List;
import org.apache.log4j.Logger;

public class BOSEventProducer
implements IEventProducer {
    private Logger logger = Logger.getLogger(BOSEventProducer.class);

    @Override
    public String getEventProducerName() {
        return this.getClass().getName();
    }

    @Override
    public ICommonEvent produceEvent(com.kingdee.bos.event.model.cem.CommonEvent commoneventDef, ServiceContext serviceContext, EventMappingInfo mappingInfo) throws CommonEventException {
        List parameters;
        BOSEntityMappingInfo[] infos;
        BOSEventUtils.debugLogger(this.logger, "=====BOSEventProducer ProduceEvent ===");
        if (commoneventDef == null || serviceContext == null) {
            return null;
        }
        CommonEvent commonEvent = new CommonEvent(commoneventDef.getName());
        commonEvent.setEventDefId(commoneventDef.getId());
        commonEvent.setEventType(commoneventDef.getType());
        commonEvent.setGroup(commoneventDef.getGroup());
        commonEvent.setPriority(EventPriority.getEnum(commoneventDef.getPriority()));
        commonEvent.setSeverity(EventSeverity.getEnum(commoneventDef.getSeverity()));
        commonEvent.setVersion(commoneventDef.getVersion());
        commonEvent.setAlias(serviceContext.getContext().getLocale(), commoneventDef.getAlias());
        commonEvent.setDescription(serviceContext.getContext().getLocale(), commoneventDef.getDescription());
        commonEvent.setSolutionName(serviceContext.getContext().getSolution());
        commonEvent.setDataCenterName(serviceContext.getContext().getAIS());
        commonEvent.setContextDataValue("userId", serviceContext.getContext().getCaller().toString());
        try {
            if (!StringUtils.isEmpty((String)commoneventDef.getExpirationDate())) {
                commonEvent.setExpiredTime(Utilities.convetToDate(commoneventDef.getExpirationDate()));
            }
        }
        catch (ParseException e) {
            BOSEventUtils.debugLogger(this.logger, e);
        }
        for (ExtendedData data : commoneventDef.getExtendedDatas().getExtendedData()) {
            EventExtendedData eed = new EventExtendedData(data.getName(), EventDataType.getEnum(data.getDataType()), data.getValue() != null ? data.getValue() : data.getDefaultValue(), data.getMappingParameterName());
            commonEvent.addExtendedData(eed);
        }
        if (mappingInfo != null && (infos = BOSEventUtils.getMatchedMappingInfos((IServiceContext)serviceContext, mappingInfo)) != null && infos.length > 0 && infos[0] != null && (parameters = infos[0].getParameterMappings()).size() > 0) {
            for (int i = 0; i < parameters.size(); ++i) {
                BOSParameterMappingInfo info = (BOSParameterMappingInfo)parameters.get(i);
                int index = Integer.valueOf(info.getActualParameterIndex());
                Object value = serviceContext.getOperationParameters()[index + 1];
                Object realValue = value;
                if (realValue instanceof IObjectValueAgent) {
                    // empty if block
                }
                this.modifyExtendedData(commonEvent, info.getFormalParameterName(), value);
            }
        }
        return commonEvent;
    }

    private void modifyExtendedData(ICommonEvent commonEvent, String extendedDataName, Object value) throws EventValidationException {
        if (commonEvent.existExtendedData(extendedDataName)) {
            commonEvent.setExtendedDataValue(extendedDataName, value);
        } else {
            commonEvent.addExtendedData(extendedDataName, EventDataType.getEnum(BOSEventUtils.getCanonicalName(value)), value);
        }
    }
}

