/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.event.producer;

import com.kingdee.bos.event.CommonEvent;
import com.kingdee.bos.event.EventDataType;
import com.kingdee.bos.event.EventPriority;
import com.kingdee.bos.event.EventSeverity;
import com.kingdee.bos.event.ICommonEvent;
import com.kingdee.bos.event.adapter.BOSEventUtils;
import com.kingdee.bos.event.adapter.EventMappingInfo;
import com.kingdee.bos.event.exception.CommonEventException;
import com.kingdee.bos.event.exception.EventValidationException;
import com.kingdee.bos.event.model.cem.ExtendedData;
import com.kingdee.bos.event.producer.IEventProducer;
import com.kingdee.bos.event.util.Utilities;
import com.kingdee.bos.service.ServiceContext;
import com.kingdee.util.StringUtils;
import java.text.ParseException;
import org.apache.log4j.Logger;

public class EAIEventProducer
implements IEventProducer {
    private Logger logger = Logger.getLogger(EAIEventProducer.class);

    @Override
    public String getEventProducerName() {
        return this.getClass().getName();
    }

    @Override
    public ICommonEvent produceEvent(com.kingdee.bos.event.model.cem.CommonEvent commoneventDef, ServiceContext serviceContext, EventMappingInfo mappingInfo) throws CommonEventException {
        if (commoneventDef == null || serviceContext == null) {
            return null;
        }
        CommonEvent commonEvent = new CommonEvent(commoneventDef.getName());
        commonEvent.setEventDefId(commoneventDef.getId());
        commonEvent.setEventType(commoneventDef.getType());
        commonEvent.setGroup(commoneventDef.getGroup());
        commonEvent.setPriority(EventPriority.getEnum(commoneventDef.getPriority()));
        commonEvent.setSeverity(EventSeverity.getEnum(commoneventDef.getSeverity()));
        commonEvent.setVersion(commoneventDef.getVersion());
        commonEvent.setAlias(serviceContext.getContext().getLocale(), commoneventDef.getAlias());
        commonEvent.setDescription(serviceContext.getContext().getLocale(), commoneventDef.getDescription());
        commonEvent.setSolutionName(serviceContext.getContext().getSolution());
        commonEvent.setDataCenterName(serviceContext.getContext().getAIS());
        try {
            if (!StringUtils.isEmpty((String)commoneventDef.getExpirationDate())) {
                commonEvent.setExpiredTime(Utilities.convetToDate(commoneventDef.getExpirationDate()));
            }
        }
        catch (ParseException e) {
            BOSEventUtils.debugLogger(this.logger, e);
        }
        for (ExtendedData data : commoneventDef.getExtendedDatas().getExtendedData()) {
            commonEvent.addExtendedData(data.getName(), EventDataType.getEnum(data.getDataType()), data.getValue() != null ? data.getValue() : data.getDefaultValue());
        }
        this.modifyExtendedData(commonEvent, "boType", serviceContext.getBoType().toString());
        this.modifyExtendedData(commonEvent, "methodPk", serviceContext.getOperationPK().getFullName());
        this.modifyExtendedData(commonEvent, "metaType", serviceContext.getMetaType().toString());
        this.modifyExtendedData(commonEvent, "uiOrFunctionPK", serviceContext.getUiOrFunctionPK() != null ? serviceContext.getUiOrFunctionPK().toString() : "");
        this.modifyExtendedData(commonEvent, "boPks", BOSEventUtils.getBoId(serviceContext));
        this.modifyExtendedData(commonEvent, "operationType", BOSEventUtils.getOperationType(serviceContext));
        return commonEvent;
    }

    private void modifyExtendedData(ICommonEvent commonEvent, String extendedDataName, Object value) throws EventValidationException {
        if (commonEvent.existExtendedData(extendedDataName)) {
            commonEvent.setExtendedDataValue(extendedDataName, value);
        } else {
            commonEvent.addExtendedData(extendedDataName, EventDataType.getEnum(BOSEventUtils.getCanonicalName(value)), value);
        }
    }
}

