/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.event.storer;

import com.kingdee.bos.event.ICommonEvent;
import com.kingdee.bos.event.core.EventServer;
import com.kingdee.bos.event.exception.EventStoreException;
import com.kingdee.bos.event.storer.ISubscriberStorer;
import com.kingdee.bos.event.storer.StorerManager;
import com.kingdee.bos.event.storer.SubscribeRelationStatus;
import com.kingdee.bos.event.storer.SubscriberRelationInfo;
import com.kingdee.util.StringUtils;
import com.kingdee.util.Uuid;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;

public class SubscriberStorer
implements ISubscriberStorer {
    private boolean persistence = false;

    public SubscriberStorer(EventServer server, StorerManager manager) {
        this.persistence = server.getConfig().isPersistence();
    }

    @Override
    public void storeSubscribeRelation(ICommonEvent commonEvent, String subscriberDestination) throws EventStoreException {
        if (commonEvent == null || StringUtils.isEmpty((String)subscriberDestination) || StringUtils.isEmpty((String)commonEvent.getId())) {
            return;
        }
        try {
            this.storeSubscribeRelation(this.constructSubscribeRelationinfo(commonEvent, subscriberDestination));
        }
        catch (SQLException e) {
            throw new EventStoreException(e);
        }
    }

    private SubscriberRelationInfo constructSubscribeRelationinfo(ICommonEvent commonEvent, String subscriberDestination) {
        if (commonEvent == null || StringUtils.isEmpty((String)subscriberDestination) || StringUtils.isEmpty((String)commonEvent.getId())) {
            return null;
        }
        SubscriberRelationInfo info = new SubscriberRelationInfo();
        info.setId(Uuid.create().toString());
        info.setEventId(commonEvent.getId());
        info.setSubscriberDestination(subscriberDestination);
        Timestamp time = new Timestamp(new Date().getTime());
        info.setCreatedTime(time);
        info.setUpdatedTime(time);
        info.setStatus(SubscribeRelationStatus.STATUS_UNSEND.getValue());
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeSubscribeRelation(SubscriberRelationInfo info) throws SQLException {
        if (!this.persistence || info == null) {
            return;
        }
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            conn = StorerManager.getConnection();
            String sql = "insert into T_CBE_SubscribeRelation(FID, FEVENTID, FSUBSCRIBERURI,FSTATUS,FCREATEDTIME,FUPDATEDTIME) values(?, ?, ?, ?, ?, ?)";
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, info.getId());
            stmt.setString(2, info.getEventId());
            stmt.setString(3, info.getSubscriberDestination());
            stmt.setString(4, info.getStatus());
            stmt.setTimestamp(5, info.getCreatedTime());
            stmt.setTimestamp(6, info.getUpdatedTime());
            stmt.executeUpdate();
        }
        catch (Throwable throwable) {
            StorerManager.cleanup(stmt, conn);
            throw throwable;
        }
        StorerManager.cleanup(stmt, conn);
    }

    @Override
    public void deleteRelationByEvent(ICommonEvent commonEvent, String subscribeUri) throws EventStoreException {
        if (!this.persistence || commonEvent == null || StringUtils.isEmpty((String)subscribeUri) || StringUtils.isEmpty((String)commonEvent.getId())) {
            return;
        }
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            conn = StorerManager.getConnection();
            String sql = "delete from T_CBE_SubscribeRelation where FEVENTID = ? and FSUBSCRIBERURI = ?";
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, commonEvent.getId());
            stmt.setString(2, subscribeUri);
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new EventStoreException(e);
            }
            catch (Throwable throwable) {
                StorerManager.cleanup(stmt, conn);
                throw throwable;
            }
        }
        StorerManager.cleanup(stmt, conn);
    }

    @Override
    public String[] getEventsBySubscribeUri(String subscribeUri) throws EventStoreException {
        if (!this.persistence || StringUtils.isEmpty((String)subscribeUri)) {
            return new String[0];
        }
        ArrayList<String> ids = new ArrayList<String>();
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet resultSet = null;
        try {
            conn = StorerManager.getConnection();
            String sql = "select FEVENTID from T_CBE_SubscribeRelation where (FSUBSCRIBERURI = ?)order by FCREATEDTIME DESC";
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, subscribeUri);
            resultSet = stmt.executeQuery();
            while (resultSet.next()) {
                ids.add(resultSet.getString("FEVENTID"));
            }
        }
        catch (SQLException e) {
            try {
                throw new EventStoreException(e);
            }
            catch (Throwable throwable) {
                StorerManager.cleanup(stmt, conn);
                throw throwable;
            }
        }
        StorerManager.cleanup(stmt, conn);
        return ids.toArray(new String[0]);
    }
}

