/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.event.subscribe;

import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.event.subscribe.EventSubscriberDefObj;
import com.kingdee.bos.event.subscribe.IEventSubscriber;
import com.kingdee.bos.event.subscribe.IEventSubscriberOrmrpcProxy;
import com.kingdee.bos.orm.ORMCoreException;
import com.kingdee.bos.orm.impl.service.SessionClosedException;
import com.kingdee.bos.rpc.RPCException;
import com.kingdee.bos.rpc.io.RPCIOException;
import com.kingdee.util.StringUtils;
import java.net.ConnectException;
import java.net.SocketException;
import java.net.UnknownHostException;
import org.apache.log4j.Logger;

public final class SubscribeInformantUtils {
    private static final Logger logger = Logger.getLogger(SubscribeInformantUtils.class);

    public static IEventSubscriber getOrmrpcSubscriber(String rpcURL, String className) {
        IEventSubscriber subscriber = null;
        try {
            subscriber = (IEventSubscriber)BOSObjectFactory.createRemoteObject((String)rpcURL, (String)className, IEventSubscriberOrmrpcProxy.class);
        }
        catch (Throwable th) {
            if (SubscribeInformantUtils.isRPCException(th) && SubscribeInformantUtils.getRPCErrorCode(th) == 1005) {
                BOSObjectFactory.clearSession((String)rpcURL);
            }
            logger.error((Object)"", th);
        }
        return subscriber;
    }

    public static boolean isRPCException(Throwable th) {
        return th instanceof ORMCoreException || th instanceof RPCException || th instanceof RPCIOException;
    }

    public static int getRPCErrorCode(Throwable th) {
        assert (th != null && SubscribeInformantUtils.isRPCException(th));
        int e = RPCException.getErrorCode((Throwable)th);
        if (e == 500) {
            Throwable cause;
            if (th instanceof SessionClosedException) {
                e = 1001;
            } else if (th instanceof ORMCoreException) {
                cause = th.getCause();
                if (cause instanceof ConnectException) {
                    e = 2004;
                } else if (cause instanceof UnknownHostException) {
                    e = 2007;
                }
            }
            if (th instanceof RPCException) {
                cause = th.getCause();
                if (cause instanceof SocketException) {
                    e = 2004;
                } else if (cause instanceof UnknownHostException) {
                    e = 2007;
                }
            }
        }
        return e;
    }

    public static IEventSubscriber getVMSubscriber(String className) {
        if (StringUtils.isEmpty((String)className)) {
            return null;
        }
        Class<?> c = null;
        Object instance = null;
        try {
            c = Class.forName(className);
            instance = c.newInstance();
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)"SubscribeInformantUtils.getVMSubscriber ClassNotFoundException", (Throwable)e);
        }
        catch (InstantiationException e) {
            logger.error((Object)"SubscribeInformantUtils.getVMSubscriber InstantiationException", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            logger.error((Object)"SubscribeInformantUtils.getVMSubscriber IllegalAccessException", (Throwable)e);
        }
        return instance;
    }

    public static EventSubscriberDefObj getEventSubscriberDefObj(String destination) {
        EventSubscriberDefObj obj = new EventSubscriberDefObj();
        if (StringUtils.isEmpty((String)destination)) {
            return obj;
        }
        String[] splitsStrings = destination.split("#");
        if (splitsStrings == null || splitsStrings.length < 3) {
            return obj;
        }
        obj.setProtocal(splitsStrings[0]);
        obj.setUri(splitsStrings[1]);
        obj.setMethod(splitsStrings[2]);
        if (splitsStrings.length > 3) {
            obj.setProcessMode(splitsStrings[3]);
        }
        return obj;
    }
}

