/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.event.subscribe;

import com.kingdee.bos.event.model.es.EventSubscribePoint;
import com.kingdee.bos.event.subscribe.ISubscriberInformant;
import com.kingdee.bos.event.subscribe.ORMRPCSubscriberInformant;
import com.kingdee.bos.event.subscribe.VMSubscriberInformant;
import com.kingdee.bos.event.subscribe.WEBSERVICESubscriberInformant;
import com.kingdee.util.StringUtils;

public class SubscriberInformantFactory {
    public static ISubscriberInformant getSubscriberInformant(EventSubscribePoint subscriber) {
        String fullUrl = subscriber.getDestination();
        if (StringUtils.isEmpty((String)fullUrl)) {
            return null;
        }
        if (fullUrl.startsWith("vm")) {
            return new VMSubscriberInformant(subscriber);
        }
        if (fullUrl.startsWith("ormrpc")) {
            return new ORMRPCSubscriberInformant(subscriber);
        }
        if (fullUrl.startsWith("webservice")) {
            return new WEBSERVICESubscriberInformant(subscriber);
        }
        throw new UnsupportedOperationException("No supported protocal : " + fullUrl);
    }
}

