/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.event.util;

import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.facade.FacadeInfo;
import com.kingdee.bos.metadata.function.FunctionObjectCollection;
import com.kingdee.bos.metadata.function.OperationCollection;
import com.kingdee.bos.metadata.function.OperationInfo;
import java.util.HashMap;
import java.util.Map;

public class BOSUtils {
    private static volatile Map operationsMap;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Map getBizEventMap(Context ctx) {
        if (operationsMap != null) return operationsMap;
        Class<BOSUtils> clazz = BOSUtils.class;
        synchronized (BOSUtils.class) {
            if (operationsMap != null) return operationsMap;
            operationsMap = BOSUtils.initOperationsMap(ctx);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return operationsMap;
        }
    }

    private static HashMap initOperationsMap(Context ctx) {
        HashMap<String, OperationInfo> operationsMap = new HashMap<String, OperationInfo>();
        FunctionObjectCollection functions = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getFunctions();
        OperationCollection operations = null;
        if (functions != null) {
            for (int i = 0; i < functions.size(); ++i) {
                operations = functions.get(i).getOperation();
                if (operations == null) continue;
                for (int j = 0; j < operations.size(); ++j) {
                    OperationInfo info = operations.get(j);
                    FacadeInfo bo = null;
                    if (info.getFacadeObjectRef() != null) {
                        bo = info.getFacadeObjectRef();
                    } else if (info.getEntityObjectRef() != null) {
                        bo = info.getEntityObjectRef();
                    }
                    String boTypeMeta = bo.getType().toString();
                    String methodId = info.getMethodRef().getInnerID() + boTypeMeta;
                    operationsMap.put(methodId, info);
                }
            }
        }
        return operationsMap;
    }
}

