/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.event.util;

import com.kingdee.bos.event.exception.EventParseException;
import com.kingdee.bos.event.util.Utilities;
import com.kingdee.util.Base64Encoder;
import com.kingdee.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.UnsupportedEncodingException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.Date;
import org.apache.log4j.Logger;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;

public class XmlUtils {
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    public static final String INDENT = "\t";
    public static final String ENCODEING = "UTF-8";
    private static final Logger logger = Logger.getLogger(XmlUtils.class);

    public static String readText(Element element) {
        if (element == null) {
            throw new IllegalArgumentException();
        }
        String val = element.getText();
        return val == null ? null : val.intern();
    }

    public static String readStringAttr(Element element, String attrName) {
        assert (attrName != null);
        if (element == null) {
            throw new IllegalArgumentException();
        }
        String val = element.getAttributeValue(attrName);
        return val == null ? null : val.intern();
    }

    public static String readString(Element element, String subElementName, Namespace ns) {
        if (element == null) {
            throw new IllegalArgumentException();
        }
        Element subElem = element.getChild(subElementName, ns);
        if (subElem == null) {
            return null;
        }
        return XmlUtils.readText(subElem);
    }

    public static String readStringSubAttr(Element element, String subElementName, String attrName, Namespace ns) {
        if (element == null) {
            throw new IllegalArgumentException();
        }
        Element subElem = element.getChild(subElementName, ns);
        if (subElem == null) {
            return null;
        }
        return XmlUtils.readStringAttr(subElem, attrName);
    }

    public static int readInt(Element element, String subElementName, Namespace ns) {
        if (element == null) {
            throw new IllegalArgumentException();
        }
        Element subElem = element.getChild(subElementName, ns);
        if (subElem == null) {
            throw new IllegalArgumentException();
        }
        return Integer.parseInt(subElem.getText());
    }

    public static int readInt(Element element, String subElementName, Namespace ns, int defaultValue) {
        if (element == null) {
            throw new IllegalArgumentException();
        }
        Element subElem = element.getChild(subElementName, ns);
        if (subElem == null) {
            return defaultValue;
        }
        return Integer.parseInt(subElem.getText());
    }

    public static Date readDate(Element element, String subElementName, Namespace ns) throws ParseException {
        if (element == null) {
            throw new IllegalArgumentException();
        }
        Element subElem = element.getChild(subElementName, ns);
        if (subElem == null) {
            return null;
        }
        return Utilities.DF_DATE.parse(subElem.getText());
    }

    public static Timestamp readTimeStamp(Element element, String subElementName, Namespace ns) throws ParseException {
        if (element == null) {
            throw new IllegalArgumentException();
        }
        Element subElem = element.getChild(subElementName, ns);
        if (subElem == null) {
            return null;
        }
        try {
            Date date = Utilities.DF_DATETIME.parse(subElem.getText());
            return new Timestamp(date.getTime());
        }
        catch (Exception _) {
            return new Timestamp(new Date().getTime());
        }
    }

    public static String elementToString(Element element) {
        if (element != null) {
            Document XMLDoc = new Document(element);
            XMLOutputter xml = new XMLOutputter();
            Format format = Format.getPrettyFormat();
            xml.setFormat(format);
            return xml.outputString(XMLDoc);
        }
        return "";
    }

    public static Element stringToElement(String str) throws EventParseException {
        Document doc;
        ByteArrayInputStream inputStream;
        if (str == null || str.length() == 0) {
            return null;
        }
        try {
            inputStream = new ByteArrayInputStream(str.getBytes("utf-8"));
        }
        catch (UnsupportedEncodingException ex) {
            throw new EventParseException("UnsupportedEncodingException", ex);
        }
        SAXBuilder builder = new SAXBuilder("org.apache.xerces.parsers.SAXParser");
        try {
            doc = builder.build((InputStream)inputStream);
        }
        catch (Exception e) {
            throw new EventParseException("builder doc dom error.", e);
        }
        return doc.getRootElement();
    }

    public static String trim(String str) {
        return str != null ? str.trim() : null;
    }

    public static String formatString(String s) {
        if (StringUtils.isEmpty((String)s)) {
            return "";
        }
        return s;
    }

    public static String convertXMLstr(String input) {
        if (input == null) {
            return null;
        }
        StringBuffer output = new StringBuffer("");
        int len = input.length();
        for (int i = 0; i < len; ++i) {
            char ch = input.charAt(i);
            if (ch == '&') {
                output.append("&amp;");
                continue;
            }
            if (ch == '<') {
                output.append("&lt;");
                continue;
            }
            if (ch == '>') {
                output.append("&gt;");
                continue;
            }
            if (ch == '\'') {
                output.append("&apos;");
                continue;
            }
            if (ch == '\"') {
                output.append("&quot;");
                continue;
            }
            output.append(ch);
        }
        return output.toString();
    }

    public static String normalize(String string) {
        int counter;
        if (string == null) {
            return "null";
        }
        int stringLength = string.length();
        if (stringLength == 0) {
            return "";
        }
        int marker = 0;
        char[] characters = string.toCharArray();
        StringBuffer normalizedString = new StringBuffer(stringLength);
        for (counter = 0; counter < stringLength; ++counter) {
            if (characters[counter] >= '(' && (characters[counter] <= ';' || characters[counter] >= '?') && characters[counter] <= '~') continue;
            if (characters[counter] == '<') {
                normalizedString.append(characters, marker, counter - marker);
                marker = counter + 1;
                normalizedString.append("&lt;");
                continue;
            }
            if (characters[counter] == '>') {
                normalizedString.append(characters, marker, counter - marker);
                marker = counter + 1;
                normalizedString.append("&gt;");
                continue;
            }
            if (characters[counter] == '&') {
                normalizedString.append(characters, marker, counter - marker);
                marker = counter + 1;
                normalizedString.append("&amp;");
                continue;
            }
            if (characters[counter] == '\"') {
                normalizedString.append(characters, marker, counter - marker);
                marker = counter + 1;
                normalizedString.append("&quot;");
                continue;
            }
            if (characters[counter] == '\'') {
                normalizedString.append(characters, marker, counter - marker);
                marker = counter + 1;
                normalizedString.append("&apos;");
                continue;
            }
            if (characters[counter] == '\t') {
                normalizedString.append(characters, marker, counter - marker);
                marker = counter + 1;
                normalizedString.append("&#x9;");
                continue;
            }
            if (characters[counter] == '\n') {
                normalizedString.append(characters, marker, counter - marker);
                marker = counter + 1;
                normalizedString.append("&#xA;");
                continue;
            }
            if (characters[counter] == '\r') {
                normalizedString.append(characters, marker, counter - marker);
                marker = counter + 1;
                normalizedString.append("&#xD;");
                continue;
            }
            if (characters[counter] >= ' ' && characters[counter] <= '\ud7ff' || characters[counter] >= '\ue000' && characters[counter] <= '\ufffd') continue;
            normalizedString.append(characters, marker, counter - marker);
            marker = counter + 1;
            normalizedString.append('?');
        }
        if (marker == 0) {
            return string;
        }
        if (marker < counter) {
            normalizedString.append(characters, marker, counter - marker);
        }
        return normalizedString.toString();
    }

    public static String denormalize(String string) {
        int counter;
        if (string == null) {
            return "null";
        }
        int stringLength = string.length();
        if (stringLength == 0) {
            return "";
        }
        int marker = 0;
        int semiColonIndex = -1;
        String entityReferenceName = null;
        char[] characters = string.toCharArray();
        StringBuffer denormalizedString = new StringBuffer(stringLength);
        for (counter = 0; counter < stringLength; ++counter) {
            if (characters[counter] != '&' || (semiColonIndex = string.indexOf(59, counter + 1)) == -1) continue;
            entityReferenceName = string.substring(counter + 1, semiColonIndex).trim();
            if (entityReferenceName.equals("lt")) {
                denormalizedString.append(characters, marker, counter - marker);
                denormalizedString.append('<');
            } else if (entityReferenceName.equals("gt")) {
                denormalizedString.append(characters, marker, counter - marker);
                denormalizedString.append('>');
            } else if (entityReferenceName.equals("amp")) {
                denormalizedString.append(characters, marker, counter - marker);
                denormalizedString.append('&');
            } else if (entityReferenceName.equals("quot")) {
                denormalizedString.append(characters, marker, counter - marker);
                denormalizedString.append('\"');
            } else if (entityReferenceName.equals("apos")) {
                denormalizedString.append(characters, marker, counter - marker);
                denormalizedString.append('\'');
            } else if (entityReferenceName.equals("#x9") || entityReferenceName.equals("#09")) {
                denormalizedString.append(characters, marker, counter - marker);
                denormalizedString.append('\t');
            } else if (entityReferenceName.equals("#xA") || entityReferenceName.equals("#10")) {
                denormalizedString.append(characters, marker, counter - marker);
                denormalizedString.append('\n');
            } else if (entityReferenceName.equals("#xD") || entityReferenceName.equals("#13")) {
                denormalizedString.append(characters, marker, counter - marker);
                denormalizedString.append('\r');
            } else {
                denormalizedString.append(characters, marker, semiColonIndex + 1 - marker);
            }
            counter = semiColonIndex;
            marker = counter + 1;
        }
        if (marker == 0) {
            return string;
        }
        if (marker < counter) {
            denormalizedString.append(characters, marker, counter - marker);
        }
        return denormalizedString.toString();
    }

    public static String processObject2Xml(Object value) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ObjectOutputStream obj = new ObjectOutputStream(baos);
            obj.writeObject(value);
        }
        catch (IOException ioe) {
            logger.error((Object)("processObject2Xml : Object Serializable Error,IOException :" + ioe));
        }
        return Base64Encoder.byteArrayToBase64((byte[])baos.toByteArray());
    }

    public static Object processXml2Object(String xml) {
        Object object = null;
        if (StringUtils.isEmpty((String)xml)) {
            return object;
        }
        byte[] bytes = Base64Encoder.base64ToByteArray((String)xml);
        try {
            ObjectInputStream input = new ObjectInputStream(new ByteArrayInputStream(bytes));
            object = input.readObject();
        }
        catch (IOException e) {
            logger.error((Object)("processXml2Object : Object DeSerializable Error,IOException :" + e));
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)("processXml2Object : Object DeSerializable Error,ClassNotFoundException :" + e));
        }
        return object;
    }
}

