/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.autoupdater;

import com.kingdee.eas.cp.autoupdater.util.FileUtil;
import com.kingdee.eas.util.PropertiesUtil;
import com.kingdee.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UTFDataFormatException;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.input.SAXBuilder;

public class EasComponents {
    private static final String CHARSET_NAME = "UTF-8";
    private static final Logger logger = Logger.getLogger(EasComponents.class);
    private Map<String, String> md5Map = new HashMap<String, String>();

    public static EasComponents getInstance() throws Exception {
        return new EasComponents();
    }

    private EasComponents() throws Exception {
        String localDir = System.getProperty("EAS_HOME") + "/server/properties/";
        String xml = FileUtil.fileToString(localDir + "/eascomponents.xml");
        Element components = EasComponents.string2Root(xml);
        Element client = components.getChild("client");
        Element libraries = client.getChild("libraries");
        Element metas = client.getChild("metas");
        List libJars = libraries.getChildren();
        for (Element libJar : libJars) {
            String url = libJar.getAttributeValue("url");
            url = "lib" + url;
            String md5 = libJar.getAttributeValue("md5");
            this.md5Map.put(url, md5);
        }
        List metaJars = metas.getChildren();
        for (Element metaJar : metaJars) {
            String url = metaJar.getAttributeValue("url");
            url = "metas" + url;
            String md5 = metaJar.getAttributeValue("md5");
            this.md5Map.put(url, md5);
        }
    }

    private String getMD5(String filePath) {
        String md5 = this.md5Map.get(filePath);
        if (StringUtils.isEmpty((String)md5)) {
            return "";
        }
        return md5;
    }

    public boolean validate(String filePath, String md5) {
        try {
            boolean processNoFoundAsOK;
            Properties updateConfigProperties = this.getUpdateConfig();
            boolean reCalculateWhenNoFoundInEasComponentsXml = "false".equals(updateConfigProperties.getProperty("reGenLocalJnlp", "true"));
            boolean bl = processNoFoundAsOK = !reCalculateWhenNoFoundInEasComponentsXml;
            if (!filePath.endsWith(".jar")) {
                logger.debug((Object)("\u975ejar\u7ec4\u4ef6,\u65e0\u6cd5\u6821\u9a8c,\u9700\u91cd\u65b0\u8ba1\u7b97" + filePath));
                return processNoFoundAsOK;
            }
            if (!filePath.startsWith("lib/") && !filePath.startsWith("metas/")) {
                logger.debug((Object)("\u975eeas\u4e2dlib\u6216\u8005metas\u76ee\u5f55\u4e0b\u7684\u7ec4\u4ef6,\u65e0\u6cd5\u6821\u9a8c,\u9700\u91cd\u65b0\u8ba1\u7b97" + filePath));
                return processNoFoundAsOK;
            }
            String eascomponentMD5 = this.getMD5(filePath);
            if (StringUtils.isEmpty((String)eascomponentMD5)) {
                logger.debug((Object)("eascomponents.xml\u4e2d\u65e0\u6b64\u6587\u4ef6,\u65e0\u6cd5\u6821\u9a8c,\u9700\u91cd\u65b0\u8ba1\u7b97" + filePath));
                return processNoFoundAsOK;
            }
            if (eascomponentMD5.equals(md5)) {
                logger.debug((Object)("eascomponents.xml\u4e2d" + filePath + ":" + eascomponentMD5 + "==" + md5 + ",\u6821\u9a8c\u901a\u8fc7"));
                return true;
            }
            logger.debug((Object)("eascomponents.xml\u4e2d" + filePath + ":" + eascomponentMD5 + "!=" + md5 + ",\u6821\u9a8c\u4e0d\u901a\u8fc7"));
            return false;
        }
        catch (Throwable t) {
            logger.warn((Object)"\u5f02\u5e38\u4e86,\u91cd\u65b0\u8ba1\u7b97", t);
            return false;
        }
    }

    private Properties getUpdateConfig() {
        try {
            Properties updateConfigProperties = PropertiesUtil.getProperties((String)PropertiesUtil.getDefaultFullName((String)"updateConfig.properties"));
            if (null != updateConfigProperties) {
                return updateConfigProperties;
            }
            return new Properties();
        }
        catch (Throwable t) {
            logger.info((Object)"\u6ca1\u6709\u6587\u4ef6,\u53d6\u7a7a\u503c", t);
            return new Properties();
        }
    }

    private static Document string2Document(String content) throws Exception {
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        ClassLoader classLoader = SAXBuilder.class.getClassLoader();
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(content.getBytes(CHARSET_NAME));
            Thread.currentThread().setContextClassLoader(classLoader);
            SAXBuilder builder = new SAXBuilder();
            Document document = builder.build((InputStream)bais);
            return document;
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Object)"\u4e0d\u652f\u6301\u5b57\u7b26\u96c6UTF-8", (Throwable)e);
            throw e;
        }
        catch (UTFDataFormatException e) {
            logger.error((Object)"\u5b57\u7b26\u96c6\u4e0d\u7b26,\u5b9e\u9645\u62a5\u6587\u5b57\u7b26\u96c6\u4e0d\u662fUTF-8", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            logger.error((Object)("\u62a5\u6587\u4e0d\u662fxml\u683c\u5f0f,\u5176\u5185\u5bb9\u4e3a :" + content), (Throwable)e);
            throw e;
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    public static Element string2Root(String content) throws Exception {
        Document document = EasComponents.string2Document(content);
        return document.getRootElement();
    }

    public static void main(String[] args) throws Exception {
        System.setProperty("EAS_HOME", "w:/eas/Server");
        EasComponents reader = new EasComponents();
        String md5 = reader.getMD5("lib/client/eas/eas_resource_common_ico.jar");
        System.out.println(md5);
    }
}

