/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.autoupdater.util;

import com.kingdee.bos.dao.xml.impl.MetadataIndexer;
import com.kingdee.eas.cp.autoupdater.CreateJnlpResourcesBean;
import com.kingdee.eas.cp.autoupdater.util.FileLists;
import com.kingdee.eas.cp.autoupdater.util.JNLPUtil;
import com.kingdee.eas.cp.autoupdater.util.MD5Util;
import com.kingdee.eas.cp.autoupdater.util.PackageMapGenerator;
import com.kingdee.util.StringUtils;
import com.twmacinta.util.MD5;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ResourceListGenerator {
    public static String ONDEMAND_RESOURCE_FILENAME = "resource.lst";
    public static String BASE_RESOURCE_FILENAME = "ondemand_eas.jnlp";
    public static String FULL_RESOURCE_FILENAME = "full_eas.jnlp";
    public static String PACKAGEMAP_RESOURCE_FILENAME = "pkmap.lst";
    public static String METAS_RESOURCE_TEMP_FILENAME = "index.lst";
    public static String METAS_RESOURCE_JAR_FILENAME = "metasindex.jar";
    public static String JNLP_PROPERTIES = "jnlp.properties";
    public static String RESOURCESET_FILENAME = "resourceSet.properties";
    public static final String FIRSTDOWNRES_FILENAME = "FirstDownRes.properties";
    public static String RELATIVE_PATH = "/classloader/";
    public static String METAS_PATH = "/metas/";
    public static String coreBase_path = "#coreBasePath#";
    public static String coreBase_defaultpath = "http://localhost:6888/easWebClient/";
    public static String easJnlp_fileName = "#easJnlpFileName#";
    public static String ONDEMAND_JNLP_VERSION = "ondemandJnlpVersion";
    public static String FULL_JNLP_VERSION = "fullJnlpVersion";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createEasJnlpResource(String localDir) {
        System.setProperty("portal.config", localDir + "/portalConfig.xml");
        HashMap<String, String> fileArgs = new HashMap<String, String>();
        String pathPrev = "";
        String extName = "";
        String jnlpResourcePaths = "";
        String autoLoadPaths = "";
        String seperator = "";
        String itemsExcluded = "";
        String autoloadItemsExcluded = "";
        String fullloadItemsExclude = "";
        String prolocalDir = System.getProperty("EAS_HOME") + "/server/properties/";
        String isScan = "true";
        File resourceFileHandler = new File(localDir, RESOURCESET_FILENAME);
        File FirstDownResFile = new File(localDir, FIRSTDOWNRES_FILENAME);
        Vector<String> FirstDownResVect = new Vector<String>();
        if (resourceFileHandler.exists()) {
            FileInputStream is = null;
            try {
                is = new FileInputStream(resourceFileHandler);
                Properties prop = new Properties();
                prop.load(is);
                pathPrev = prop.getProperty("fileserverDir");
                jnlpResourcePaths = prop.getProperty("baseResPaths");
                autoLoadPaths = prop.getProperty("ondemand_resPaths");
                seperator = prop.getProperty("seperator");
                itemsExcluded = prop.getProperty("full_resItemsExcluded");
                autoloadItemsExcluded = prop.getProperty("ondemand_resItemsExcluded");
                isScan = prop.getProperty("isScan");
                if (pathPrev != null && pathPrev.indexOf("${EAS_HOME}") >= 0 && System.getProperty("EAS_HOME") != null) {
                    pathPrev = ResourceListGenerator.replaceMacro(pathPrev, "EAS_HOME", System.getProperty("EAS_HOME"));
                }
            }
            catch (Exception e) {
                isScan = "true";
                isScan = "true";
                System.out.println("load " + RESOURCESET_FILENAME + " error.");
                e.printStackTrace();
            }
            finally {
                try {
                    if (is != null) {
                        ((InputStream)is).close();
                    }
                }
                catch (IOException ex1) {
                    System.out.println("IOException when closing!");
                }
            }
        }
        if ("false".equalsIgnoreCase(isScan)) {
            return;
        }
        if (FirstDownResFile.exists()) {
            BufferedReader in = null;
            try {
                in = new BufferedReader(new InputStreamReader(new FileInputStream(FirstDownResFile)));
                String line = null;
                while (true) {
                    try {
                        line = in.readLine();
                    }
                    catch (IOException e) {
                        System.out.println("file FirstDownRes.properties has a bad line!");
                    }
                    if (line == null) {
                        break;
                    }
                    line = StringUtils.trim((String)line);
                    FirstDownResVect.add(line);
                }
            }
            catch (FileNotFoundException e) {
                System.out.println("file FirstDownRes.properties not found!");
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        System.out.println("IOException when closing!");
                    }
                }
            }
        }
        if (ResourceListGenerator.isEmpty(pathPrev)) {
            throw new RuntimeException("cann't find the fileserver dir!");
        }
        if (ResourceListGenerator.isEmpty(jnlpResourcePaths)) {
            jnlpResourcePaths = pathPrev + "lib/";
        }
        if (ResourceListGenerator.isEmpty(autoLoadPaths)) {
            autoLoadPaths = pathPrev + "lib/";
        }
        if (ResourceListGenerator.isEmpty(seperator)) {
            seperator = ",";
        }
        if (ResourceListGenerator.isEmpty(itemsExcluded)) {
            itemsExcluded = "";
        }
        if (ResourceListGenerator.isEmpty(autoloadItemsExcluded)) {
            autoloadItemsExcluded = "";
        }
        fullloadItemsExclude = new String(autoloadItemsExcluded);
        String ClItemsExcluded = autoloadItemsExcluded;
        autoloadItemsExcluded = ResourceListGenerator.addToArray(FirstDownResVect, autoloadItemsExcluded);
        jnlpResourcePaths = ResourceListGenerator.addToArray(FirstDownResVect, jnlpResourcePaths);
        String baseDir = pathPrev;
        String fileName = "kdjnlp.entries";
        String easJnlpPath = coreBase_path;
        String jnlpResources = null;
        fileArgs.put("configDir", prolocalDir);
        fileArgs.put("pathPrefix", pathPrev);
        fileArgs.put("extName", extName);
        fileArgs.put("seperator", seperator);
        fileArgs.put("fileName", fileName);
        fileArgs.put("easJnlpCodeBase", easJnlpPath);
        fileArgs.put("baseDir", baseDir);
        fileArgs.put("rewrite", "true");
        fileArgs.put("easJnlpFileName", easJnlp_fileName);
        fileArgs.put("itemExcluded", ClItemsExcluded);
        long startTime = System.currentTimeMillis();
        System.out.println("[easupdater] create pkmap resource start.");
        boolean modified = PackageMapGenerator.generatePKMap(baseDir, autoLoadPaths, baseDir + "/" + RELATIVE_PATH + "/", PACKAGEMAP_RESOURCE_FILENAME, prolocalDir);
        System.out.println("[easupdater] create pkmap resource end.used time:" + (System.currentTimeMillis() - startTime) + "ms");
        if (modified) {
            startTime = System.currentTimeMillis();
            System.out.println("[easupdater] create metadata index start.");
            try {
                File meTemp = new File(baseDir + "/" + METAS_PATH + "/" + METAS_RESOURCE_JAR_FILENAME);
                if (meTemp.exists()) {
                    String tmpVersion = MD5.getMD5(meTemp);
                    System.out.println("before create metasindex.jar ,the old ,md5version is " + tmpVersion);
                }
                MetadataIndexer.index((File[])ResourceListGenerator.getMetaDir(baseDir, autoLoadPaths), (String)localDir);
                Properties rtv = new Properties();
                FileInputStream indexLoader = new FileInputStream(new File(localDir, "index.lst"));
                rtv.load(indexLoader);
                ((InputStream)indexLoader).close();
                try {
                    ByteArrayOutputStream pkMapWriter = new ByteArrayOutputStream();
                    BufferedOutputStream bufPKMapWriter = new BufferedOutputStream(pkMapWriter);
                    Object[] keys = rtv.keySet().toArray(new String[0]);
                    Arrays.sort(keys);
                    for (int i = 0; i < keys.length; ++i) {
                        bufPKMapWriter.write(((String)keys[i]).getBytes());
                        bufPKMapWriter.write("=".getBytes());
                        bufPKMapWriter.write(((String)rtv.get(keys[i])).getBytes());
                        bufPKMapWriter.write("\r\n".getBytes());
                    }
                    bufPKMapWriter.flush();
                    FileOutputStream dest = new FileOutputStream(baseDir + "/" + METAS_PATH + "/" + METAS_RESOURCE_JAR_FILENAME);
                    ZipOutputStream out = new ZipOutputStream(new BufferedOutputStream(dest));
                    ZipEntry entry = new ZipEntry("index.lst");
                    entry.setTime(0L);
                    out.putNextEntry(entry);
                    out.write(pkMapWriter.toByteArray());
                    out.closeEntry();
                    out.finish();
                    out.close();
                }
                catch (Throwable ex) {
                    System.err.println("[easupdater] store metasIndex failed, cause by " + ex.getMessage());
                    ex.printStackTrace();
                }
                File meTempAfter = new File(baseDir + "/" + METAS_PATH + "/" + METAS_RESOURCE_JAR_FILENAME);
                if (meTempAfter.exists()) {
                    String tmpVersionAfter = MD5.getMD5(meTempAfter);
                    System.out.println("after create metasindex.jar ,the new md5version is " + tmpVersionAfter);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            System.out.println("[easupdater] create metadata index end.used time:" + (System.currentTimeMillis() - startTime) + "ms");
            startTime = System.currentTimeMillis();
            System.out.println("[easupdater] create ondemand jnlp resource start.");
            fileArgs.put("pathSuffixStr", autoLoadPaths);
            jnlpResources = CreateJnlpResourcesBean.createJnlpString(fileArgs);
            jnlpResources = ResourceListGenerator.reSetJnlp(jnlpResources, (String)fileArgs.get("easJnlpFileName"));
            FileLists.createEasJnlpWithUTF8(new File(baseDir + "/" + RELATIVE_PATH + "/"), jnlpResources, ONDEMAND_RESOURCE_FILENAME);
            fileArgs.put("itemExcluded", autoloadItemsExcluded);
            jnlpResources = CreateJnlpResourcesBean.createJnlpString(fileArgs);
            FileLists.createEasJnlpWithUTF8(new File(prolocalDir + "/"), jnlpResources, ONDEMAND_RESOURCE_FILENAME);
            System.out.println("[easupdater] create ondemand jnlp resource file:" + ONDEMAND_RESOURCE_FILENAME);
            System.out.println("[easupdater] create ondemand jnlp resource file content length:" + jnlpResources.length());
            System.out.println("[easupdater] create ondemand jnlp resource end.used time:" + (System.currentTimeMillis() - startTime) + "ms");
        } else {
            System.out.println("[easupdater] ondemand jnlp no modified.");
        }
        CreateJnlpResourcesBean.setModified(false);
        easJnlpPath = coreBase_path;
        fileArgs.put("easJnlpCodeBase", easJnlpPath);
        startTime = System.currentTimeMillis();
        System.out.println("[easupdater] create base jnlp resource start.");
        fileArgs.put("pathSuffixStr", jnlpResourcePaths);
        fileArgs.put("itemExcluded", fullloadItemsExclude);
        jnlpResources = CreateJnlpResourcesBean.createJnlpString(fileArgs);
        if (CreateJnlpResourcesBean.isModified()) {
            FileLists.createEasJnlpWithUTF8(new File(prolocalDir + "/"), jnlpResources, BASE_RESOURCE_FILENAME);
            JNLPUtil.getJNLPProperties(prolocalDir).setProperty(ONDEMAND_JNLP_VERSION, "" + System.currentTimeMillis());
            JNLPUtil.storeJNLPProperties(prolocalDir);
        } else {
            System.out.println("[easupdater] base jnlp no modified.");
        }
        System.out.println("[easupdater] create base jnlp resource end.used time:" + (System.currentTimeMillis() - startTime) + "ms");
        String temp = null;
        temp = !jnlpResourcePaths.equals("") ? (!autoLoadPaths.equals("") ? autoLoadPaths + seperator + jnlpResourcePaths : jnlpResourcePaths) : autoLoadPaths;
        if (CreateJnlpResourcesBean.isModified() || modified) {
            startTime = System.currentTimeMillis();
            System.out.println("[easupdater] create full jnlp resource start.");
            fileArgs.put("itemExcluded", itemsExcluded);
            fileArgs.put("pathSuffixStr", temp);
            jnlpResources = CreateJnlpResourcesBean.createJnlpString(fileArgs);
            FileLists.createEasJnlpWithUTF8(new File(prolocalDir + "/"), jnlpResources, FULL_RESOURCE_FILENAME);
            JNLPUtil.getJNLPProperties(prolocalDir).setProperty(FULL_JNLP_VERSION, "" + System.currentTimeMillis());
            JNLPUtil.storeJNLPProperties(prolocalDir);
            System.out.println("[easupdater] create full jnlp resource end.used time:" + (System.currentTimeMillis() - startTime) + "ms");
            startTime = System.currentTimeMillis();
            MD5Util.storeVersion(pathPrev);
            System.out.println("[easupdater] store MD5 Version.used time:" + (System.currentTimeMillis() - startTime) + "ms");
        } else {
            System.out.println("[easupdater] full jnlp no modified.");
        }
    }

    private static String reSetJnlp(String jnlpResources, String easJnlpFileName) {
        StringBuffer sb = new StringBuffer("");
        sb.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>\r\n");
        sb.append("\t\t<jnlp spec=\"1.0+\" codebase=\"" + coreBase_defaultpath + "\" href=\"" + easJnlpFileName + "\" ");
        jnlpResources = sb.toString() + jnlpResources;
        return jnlpResources;
    }

    private static String addToArray(Vector vect, String str) {
        StringBuffer buf = new StringBuffer(str);
        if (vect.size() > 0) {
            Iterator it = vect.iterator();
            String tempStr = null;
            while (it.hasNext()) {
                tempStr = (String)it.next();
                buf.append(",");
                buf.append(tempStr);
            }
        }
        return buf.toString();
    }

    private static String replaceMacro(String source, String macro, String value) {
        int startIndex = 0;
        int openIndex = source.indexOf("${", startIndex);
        if (openIndex == -1) {
            return source;
        }
        int closeIndex = source.indexOf(125, startIndex);
        if (closeIndex == -1 || openIndex > closeIndex) {
            return source;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(source.substring(startIndex, openIndex));
        while (true) {
            String key;
            if ((key = source.substring(openIndex + 2, closeIndex)).equals(macro)) {
                sb.append(value);
            } else {
                sb.append("${").append(key).append("}");
            }
            startIndex = closeIndex + 1;
            openIndex = source.indexOf("${", startIndex);
            if (openIndex == -1) {
                sb.append(source.substring(startIndex));
                break;
            }
            closeIndex = source.indexOf(125, startIndex);
            if (closeIndex == -1 || openIndex > closeIndex) {
                sb.append(source.substring(startIndex));
                break;
            }
            sb.append(source.substring(startIndex, openIndex));
        }
        return sb.toString();
    }

    private static File[] getMetaDir(String baseDir, String autoLoadPaths) {
        String libPath = autoLoadPaths;
        File[] paths = null;
        Vector<File> vect = new Vector<File>();
        String[] libList = libPath.split(",");
        for (int i = 0; i < libList.length; ++i) {
            File[] temp;
            String path = libList[i];
            if (!path.startsWith("metas")) continue;
            File metaPath = new File(baseDir + "/" + path + "/");
            if (metaPath.isFile()) {
                vect.add(metaPath);
                continue;
            }
            if (!metaPath.isDirectory() || (temp = metaPath.listFiles()) == null) continue;
            for (int j = 0; j < temp.length; ++j) {
                vect.add(temp[j]);
            }
        }
        int size = vect.size();
        paths = new File[size];
        for (int i = 0; i < size; ++i) {
            paths[i] = (File)vect.get(i);
        }
        return paths;
    }

    public static boolean isEmpty(String nullStr) {
        return nullStr == null || "".equals(nullStr);
    }
}

