/*
 * Decompiled with CFR 0.152.
 */
package net.buffalo.protocal;

import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import net.buffalo.protocal.BuffaloCall;
import net.buffalo.protocal.converters.ConverterLookup;
import net.buffalo.protocal.converters.DefaultConverterLookup;
import net.buffalo.protocal.io.DefaultMarshallingStrategy;
import net.buffalo.protocal.io.FastInputStreamReader;
import net.buffalo.protocal.io.FastStreamReader;
import net.buffalo.protocal.io.FastStreamWriter;
import net.buffalo.protocal.io.MarshallingStrategy;

public class BuffaloProtocal {
    private MarshallingStrategy marshallingStrategy = new DefaultMarshallingStrategy();
    private ConverterLookup converterLookup = new DefaultConverterLookup();
    private static BuffaloProtocal instance = null;

    private BuffaloProtocal() {
    }

    public static BuffaloProtocal getInstance() {
        if (instance == null) {
            instance = new BuffaloProtocal();
        }
        return instance;
    }

    public BuffaloCall deserialize(String source) {
        return this.unmarshall(new StringReader(source));
    }

    public String serialize(Object value) {
        StringWriter writer = new StringWriter();
        this.marshall(value, writer);
        return writer.getBuffer().toString();
    }

    public void marshall(Object value, Writer writer) {
        this.marshallingStrategy.marshal(value, this.converterLookup, new FastStreamWriter(writer));
    }

    public BuffaloCall unmarshall(Reader reader) {
        return this.marshallingStrategy.unmarshal(new FastStreamReader(reader), this.converterLookup);
    }

    public BuffaloCall unmarshall(InputStream inputStream) {
        return this.marshallingStrategy.unmarshal(new FastInputStreamReader(inputStream), this.converterLookup);
    }
}

