/*
 * Decompiled with CFR 0.152.
 */
package net.buffalo.protocal.converters;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import net.buffalo.protocal.ProtocolException;
import net.buffalo.protocal.converters.BigNumberConverter;
import net.buffalo.protocal.converters.Converter;
import net.buffalo.protocal.converters.ConverterLookup;
import net.buffalo.protocal.converters.ExceptionConverter;
import net.buffalo.protocal.converters.ReferenceConverter;
import net.buffalo.protocal.converters.SqlDateConverter;
import net.buffalo.protocal.converters.basic.BooleanConverter;
import net.buffalo.protocal.converters.basic.DateConverter;
import net.buffalo.protocal.converters.basic.DoubleConverter;
import net.buffalo.protocal.converters.basic.IntegerConverter;
import net.buffalo.protocal.converters.basic.LongConverter;
import net.buffalo.protocal.converters.basic.NullConverter;
import net.buffalo.protocal.converters.basic.StringConverter;
import net.buffalo.protocal.converters.collection.ArrayConverter;
import net.buffalo.protocal.converters.collection.CollectionConverter;
import net.buffalo.protocal.converters.map.MapConverter;
import net.buffalo.protocal.converters.map.ObjectConverter;

public class DefaultConverterLookup
implements ConverterLookup {
    private Map converterCache;
    private Map tagNameConverterCache;
    private ArrayList converters = new ArrayList(12);
    Converter nullConverter;

    public DefaultConverterLookup() {
        this.converterCache = new HashMap();
        this.nullConverter = new NullConverter();
        this.tagNameConverterCache = new Hashtable(10);
        this.registerDefaultConverters();
    }

    @Override
    public Converter lookupConverterForType(Class type) {
        Converter result = null;
        if (this.converterCache.get(type) == null) {
            for (int i = 0; i < this.converters.size(); ++i) {
                Converter converter = (Converter)this.converters.get(i);
                if (!converter.canConvert(type)) continue;
                this.converterCache.put(type, converter);
                result = converter;
                break;
            }
        } else {
            result = (Converter)this.converterCache.get(type);
        }
        return result;
    }

    protected void registerDefaultConverters() {
        BooleanConverter booleanConverter = new BooleanConverter();
        DoubleConverter doubleConverter = new DoubleConverter();
        IntegerConverter integerConverter = new IntegerConverter();
        LongConverter longConverter = new LongConverter();
        StringConverter stringConverter = new StringConverter();
        DateConverter dateConverter = new DateConverter();
        CollectionConverter collectionConverter = new CollectionConverter();
        MapConverter mapConverter = new MapConverter();
        ArrayConverter arrayConverter = new ArrayConverter();
        SqlDateConverter sqlDateConverter = new SqlDateConverter();
        BigNumberConverter bigNumberConverter = new BigNumberConverter();
        ExceptionConverter exceptionConverter = new ExceptionConverter();
        ObjectConverter objectConverter = new ObjectConverter();
        this.converters.add(this.nullConverter);
        this.converters.add(booleanConverter);
        this.converters.add(doubleConverter);
        this.converters.add(integerConverter);
        this.converters.add(longConverter);
        this.converters.add(stringConverter);
        this.converters.add(dateConverter);
        this.converters.add(collectionConverter);
        this.converters.add(mapConverter);
        this.converters.add(arrayConverter);
        this.converters.add(sqlDateConverter);
        this.converters.add(bigNumberConverter);
        this.converters.add(exceptionConverter);
        this.converters.add(objectConverter);
        this.tagNameConverterCache.put("boolean", booleanConverter);
        this.tagNameConverterCache.put("string", stringConverter);
        this.tagNameConverterCache.put("int", integerConverter);
        this.tagNameConverterCache.put("long", longConverter);
        this.tagNameConverterCache.put("double", doubleConverter);
        this.tagNameConverterCache.put("null", this.nullConverter);
        this.tagNameConverterCache.put("date", dateConverter);
        this.tagNameConverterCache.put("list", collectionConverter);
        this.tagNameConverterCache.put("map", mapConverter);
        this.tagNameConverterCache.put("ref", new ReferenceConverter());
        this.converterCache.put(Boolean.class, booleanConverter);
        this.converterCache.put(Boolean.TYPE, booleanConverter);
        this.converterCache.put(String.class, stringConverter);
        this.converterCache.put(Integer.class, integerConverter);
        this.converterCache.put(Integer.TYPE, integerConverter);
        this.converterCache.put(Long.class, longConverter);
        this.converterCache.put(Long.TYPE, longConverter);
        this.converterCache.put(Double.class, doubleConverter);
        this.converterCache.put(Double.TYPE, doubleConverter);
        this.converterCache.put(java.util.Date.class, dateConverter);
        this.converterCache.put(ArrayList.class, collectionConverter);
        this.converterCache.put(LinkedList.class, collectionConverter);
        this.converterCache.put(HashSet.class, collectionConverter);
        this.converterCache.put(Vector.class, collectionConverter);
        this.converterCache.put(TreeSet.class, collectionConverter);
        this.converterCache.put(HashMap.class, mapConverter);
        this.converterCache.put(TreeMap.class, mapConverter);
        this.converterCache.put(Date.class, sqlDateConverter);
        this.converterCache.put(BigDecimal.class, bigNumberConverter);
        this.converterCache.put(BigInteger.class, bigNumberConverter);
    }

    @Override
    public Converter getNullConverter() {
        return this.nullConverter;
    }

    @Override
    public Converter lookupConverterForTagName(String tagName) {
        Object converter = this.tagNameConverterCache.get(tagName);
        if (converter == null) {
            throw new ProtocolException("unrecoganized tag: " + tagName);
        }
        return (Converter)converter;
    }
}

