/*
 * Decompiled with CFR 0.152.
 */
package net.buffalo.protocal.converters.collection;

import java.util.Date;
import net.buffalo.protocal.converters.Converter;
import net.buffalo.protocal.converters.collection.AbstractListConverter;
import net.buffalo.protocal.io.MarshallingContext;
import net.buffalo.protocal.io.StreamReader;
import net.buffalo.protocal.io.StreamWriter;
import net.buffalo.protocal.io.UnmarshallingContext;
import net.buffalo.protocal.util.PrimitiveTypeUtil;

public class ArrayConverter
extends AbstractListConverter
implements Converter {
    @Override
    public boolean canConvert(Class type) {
        if (type == null) {
            return false;
        }
        return type.isArray();
    }

    @Override
    public void marshalObject(Object value, MarshallingContext context, StreamWriter streamWriter) {
        Object[] array = (Object[])PrimitiveTypeUtil.toWrapperArrayIfNeeded(value);
        this.writeListHeader(streamWriter, this.getArrayType(value.getClass()), array.length);
        for (int i = 0; i < array.length; ++i) {
            context.convertAnother(array[i]);
        }
        streamWriter.endNode();
    }

    @Override
    public Object unmarshal(StreamReader reader, UnmarshallingContext unmarshallingContext) {
        throw new UnsupportedOperationException("the CollectionConverter has done it already");
    }

    private String getArrayType(Class clazz) {
        if (clazz.isArray()) {
            return '[' + this.getArrayType(clazz.getComponentType());
        }
        String name = clazz.getName();
        if (clazz.equals(String.class)) {
            return "string";
        }
        if (clazz.equals(Object.class)) {
            return "map";
        }
        if (clazz.equals(Date.class)) {
            return "date";
        }
        if (clazz.equals(Short.TYPE) || clazz.equals(Byte.TYPE) || clazz.equals(Short.class) || clazz.equals(Byte.class) || clazz.equals(Integer.class)) {
            return "int";
        }
        if (clazz.equals(Long.class)) {
            return "long";
        }
        if (clazz.equals(Float.TYPE) || clazz.equals(Float.class) || clazz.equals(Double.TYPE) || clazz.equals(Double.class)) {
            return "double";
        }
        if (clazz.equals(Boolean.class) || clazz.equals(Boolean.TYPE)) {
            return "boolean";
        }
        return name;
    }
}

