/*
 * Decompiled with CFR 0.152.
 */
package net.buffalo.service;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.buffalo.request.AbstractRequestWorker;
import net.buffalo.request.RequestContext;
import net.buffalo.request.RequestWorker;
import net.buffalo.request.ValidationException;
import net.buffalo.service.ServiceInvocationException;
import net.buffalo.service.ServiceRepository;
import net.buffalo.service.ServiceRepositoryUtil;
import net.buffalo.service.invoker.BuffaloInvoker;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BuffaloWorker
extends AbstractRequestWorker
implements RequestWorker {
    private static final String OUTPUT_ENCODING = "utf-8";
    private static final Log LOGGER = LogFactory.getLog(BuffaloWorker.class);

    @Override
    public void processRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"invoking buffalo worker");
        }
        String requestService = this.getWorkerRelativePath();
        ServiceRepository repository = ServiceRepositoryUtil.getServiceRepository(RequestContext.getContext().getServletContext());
        Object service = repository.get(requestService);
        response.setHeader("content-type", "text/xml;charset=utf-8");
        try {
            ServletInputStream inputStream = request.getInputStream();
            BuffaloInvoker.getInstance().invoke(service, (InputStream)inputStream, (Writer)new OutputStreamWriter((OutputStream)response.getOutputStream(), OUTPUT_ENCODING));
        }
        catch (Throwable ex) {
            LOGGER.error((Object)"An exception occured when invoking a service: ", ex);
            StringWriter writer = new StringWriter();
            ex.printStackTrace(new PrintWriter(writer));
            StringBuffer faultString = new StringBuffer();
            faultString.append("An exception occured when invoking a service. \n");
            faultString.append(writer.toString());
            throw new ServiceInvocationException(faultString.toString(), ex);
        }
    }

    public void validate() throws ValidationException {
        if (!RequestContext.getContext().getHttpRequest().getMethod().equals("POST")) {
            throw new ValidationException("Buffalo worker support POST only!");
        }
    }

    @Override
    public void validate(HttpServletRequest request, HttpServletResponse response) throws ValidationException {
        if (!request.getMethod().equals("POST")) {
            throw new ValidationException("Buffalo worker support POST only!");
        }
    }
}

