/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.eip.sso;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.UserContextCallback;
import com.kingdee.bos.framework.session.BOSLoginException;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.myeas.IPersonalParam;
import com.kingdee.eas.base.myeas.PersonalParamCollection;
import com.kingdee.eas.base.myeas.PersonalParamFactory;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.permission.UserException;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.app.util.UserInfoUtils;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.cp.eip.sso.AbstractEasAuthHandler;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.Locale;

public class EasDefaultAuthHandler
extends AbstractEasAuthHandler {
    private final String[] defaultAdminNumber = new String[]{"administrator", "authenadmin", "sscAdmin", "auditadmin", "virtualUser"};

    @Override
    public String getEasUserNumber(Context ctx, String externalUserNumber) throws BOSLoginException {
        try {
            String adminLoginByLoginNumber = ParamManager.getParamValue((Context)ctx, null, (String)"AdminLoginByLoginNumber");
            if (!"true".equalsIgnoreCase(adminLoginByLoginNumber)) {
                externalUserNumber = this.checkLoginType(ctx, externalUserNumber);
                return externalUserNumber;
            }
            boolean flag = false;
            for (String number : this.defaultAdminNumber) {
                if (!number.equalsIgnoreCase(externalUserNumber)) continue;
                flag = true;
                break;
            }
            if (flag) {
                UserInfo userInfo = UserInfoUtils.getUserInfo4LoinModule((Context)ctx, (String)externalUserNumber);
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)"select floginnumber from t_pm_user where upper(fnumber)=?", (Object[])new Object[]{externalUserNumber.toUpperCase()});
                UserException ex = null;
                if (rs.next() && !StringUtils.isEmpty((String)rs.getString(1))) {
                    ex = new UserException(UserException.LOGINNAME_HASBEEN_SET, new Object[]{externalUserNumber});
                } else {
                    IPersonalParam pp = PersonalParamFactory.getLocalInstance((Context)ctx);
                    PersonalParamCollection coll = pp.getPersonalParamCollection("where user.id='" + userInfo.getId().toString() + "' and paramName='ADMIN_LOGINNUMBER_FIRST'");
                    if (coll.size() < 1) {
                        return externalUserNumber;
                    }
                    ex = new UserException(UserException.DEFAULT_USERNAME);
                }
                if (userInfo != null) {
                    ContextUtil.setCurrentUserInfo((Context)ctx, (UserInfo)userInfo);
                    ContextUtil.setCurrentCtrlUnit((Context)ctx, (CtrlUnitInfo)userInfo.getCU());
                    String desc = ResourceBase.getString((String)"com.kingdee.eas.cp.eip.sso.web.auth.LoginFrameResxResource", (String)"login_error", (Locale)ctx.getLocale());
                    LogUtil.beginLog((Context)ctx, (String)"UserLogin", (BOSObjectType)new BOSObjectType("1DBFA8A7"), null, (String)(desc + ":" + ex.getMessage(ctx.getLocale())));
                }
                throw ex;
            }
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)"select fnumber from t_pm_user where upper(floginnumber)=?", (Object[])new Object[]{externalUserNumber.toUpperCase()});
            if (rs.next() && !StringUtils.isEmpty((String)rs.getString(1))) {
                return rs.getString(1);
            }
            return externalUserNumber;
        }
        catch (Exception e) {
            throw new BOSLoginException((Throwable)e);
        }
    }

    private String checkLoginType(Context ctx, String originUserName) throws SQLException, BOSException {
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)"select fnumber from t_pm_user where upper(fnumber)=?", (Object[])new Object[]{originUserName.toUpperCase()});
        if (rs.next() && !StringUtils.isEmpty((String)rs.getString(1))) {
            return rs.getString("fnumber");
        }
        rs = DbUtil.executeQuery((Context)ctx, (String)"select fnumber from t_pm_user where fcell=?", (Object[])new Object[]{originUserName});
        if (rs.next() && !StringUtils.isEmpty((String)rs.getString(1))) {
            if (rs.size() != 1) {
                return originUserName;
            }
            return rs.getString("fnumber");
        }
        rs = DbUtil.executeQuery((Context)ctx, (String)"select fnumber from t_pm_user where femail=?", (Object[])new Object[]{originUserName});
        if (rs.next() && !StringUtils.isEmpty((String)rs.getString(1))) {
            if (rs.size() != 1) {
                return originUserName;
            }
            return rs.getString("fnumber");
        }
        return originUserName;
    }

    @Override
    public boolean isVerifyEasUserPwd() {
        return true;
    }

    @Override
    public boolean authenticate(UserContextCallback userCtxCallback, String userNumber, String password) throws BOSLoginException {
        return true;
    }
}

