/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.eip.sso.kd.ltpa;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.eip.sso.kd.ltpa.LtpaToken;
import com.kingdee.eas.cp.eip.sso.util.BASE64Util;
import com.kingdee.eas.cp.eip.sso.util.LMBCSUtil;
import com.kingdee.util.StringUtils;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.util.Calendar;
import java.util.Date;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class LtpaTokenManager {
    private static Logger logger = Logger.getLogger(LtpaTokenManager.class);
    private static final String DOMINO_SECRET = "domino.secret";
    private static final String TOKEN_EXPIRATION = "token.expiration";
    private static final String ISLMBCSENCODE = "isLMBCSEncode";
    private static Properties properties = null;
    private static boolean existSSOConfig = true;
    private static Object lockObj;

    public static String getPhoneByUseID(Context ctx, String userID) throws EASBizException, BOSException {
        logger.error((Object)("\u7528\u6237ID\u4e3a " + userID));
        if (StringUtils.isEmpty((String)userID)) {
            logger.error((Object)"\u7528\u6237ID\u4e3a\u7a7a\uff01");
            return null;
        }
        String phone = null;
        String oql = "select *, person.* where id = '" + userID + "'";
        UserInfo userInfo = UserFactory.getLocalInstance((Context)ctx).getUserInfo(oql);
        if (userInfo == null) {
            logger.error((Object)("\u4e0d\u5b58\u5728\u7528\u6237ID\u4e3a " + userID + " \u7684\u7528\u6237\u4fe1\u606f\uff01"));
            return null;
        }
        phone = userInfo.getCell();
        if (StringUtils.isEmpty((String)phone)) {
            PersonInfo personInfo = userInfo.getPerson();
            if (personInfo == null) {
                logger.error((Object)("\u4e0d\u5b58\u5728\u7528\u6237ID\u4e3a " + userID + " \u7684\u7528\u6237\u5bf9\u5e94\u7684\u804c\u5458\u4fe1\u606f\u4e3a\u7a7a\uff01"));
                return null;
            }
            phone = personInfo.getCell();
            if (StringUtils.isEmpty((String)phone)) {
                logger.error((Object)("\u4e0d\u5b58\u5728\u7528\u6237ID\u4e3a " + userID + " \u7684\u7528\u6237\u4e0d\u5b58\u5728\u624b\u673a\u53f7\u4fe1\u606f\uff01"));
                return null;
            }
        }
        return phone;
    }

    public static String generateByUseID(Context ctx, String userID) throws EASBizException, BOSException {
        logger.error((Object)("\u7528\u6237ID\u4e3a " + userID));
        if (StringUtils.isEmpty((String)userID)) {
            logger.error((Object)"\u7528\u6237ID\u4e3a\u7a7a\uff01");
            return null;
        }
        String phone = null;
        String oql = "select *, person.* where id = '" + userID + "'";
        UserInfo userInfo = UserFactory.getLocalInstance((Context)ctx).getUserInfo(oql);
        if (userInfo == null) {
            logger.error((Object)("\u4e0d\u5b58\u5728\u7528\u6237ID\u4e3a " + userID + " \u7684\u7528\u6237\u4fe1\u606f\uff01"));
            return null;
        }
        phone = userInfo.getCell();
        if (StringUtils.isEmpty((String)phone)) {
            PersonInfo personInfo = userInfo.getPerson();
            if (personInfo == null) {
                logger.error((Object)("\u4e0d\u5b58\u5728\u7528\u6237ID\u4e3a " + userID + " \u7684\u7528\u6237\u5bf9\u5e94\u7684\u804c\u5458\u4fe1\u606f\u4e3a\u7a7a\uff01"));
                return null;
            }
            phone = personInfo.getCell();
            if (StringUtils.isEmpty((String)phone)) {
                logger.error((Object)("\u4e0d\u5b58\u5728\u7528\u6237ID\u4e3a " + userID + " \u7684\u7528\u6237\u4e0d\u5b58\u5728\u624b\u673a\u53f7\u4fe1\u606f\uff01"));
                return null;
            }
        }
        return LtpaTokenManager.generate(phone);
    }

    public static String generate(String phone) {
        Date creationDate = new Date();
        Date expirationDate = new Date();
        int interval = Integer.parseInt(properties.getProperty(TOKEN_EXPIRATION));
        expirationDate.setTime(creationDate.getTime() + (long)(60000 * interval));
        return LtpaTokenManager.generate(phone, creationDate, expirationDate);
    }

    private static String generate(String phone, Date tokenCreation, Date tokenExpires) {
        String isLMBC;
        boolean isLMBCSEncode = false;
        if (properties != null && (isLMBC = properties.getProperty(ISLMBCSENCODE)) != null && "true".equals(isLMBC)) {
            isLMBCSEncode = true;
        }
        return LtpaTokenManager.generate(phone, tokenCreation, tokenExpires, isLMBCSEncode);
    }

    private static String generate(String phone, Date tokenCreation, Date tokenExpires, boolean isLMBCSEncode) {
        LtpaToken ltpa = new LtpaToken();
        Calendar calendar = Calendar.getInstance();
        MessageDigest md = ltpa.getMessageDigest();
        ltpa.setHeader(new byte[]{0, 1, 2, 3});
        if (isLMBCSEncode) {
            ltpa.setUser(LMBCSUtil.getLMBCSLocalGroupBytes(phone));
        } else {
            try {
                ltpa.setUser(phone.getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                ltpa.setUser(phone.getBytes());
            }
        }
        byte[] token = null;
        calendar.setTime(tokenCreation);
        ltpa.setCreation(Long.toHexString(calendar.getTime().getTime() / 1000L).toUpperCase().getBytes());
        calendar.setTime(tokenExpires);
        ltpa.setExpires(Long.toHexString(calendar.getTime().getTime() / 1000L).toUpperCase().getBytes());
        token = LMBCSUtil.concatenate(token, ltpa.getHeader());
        token = LMBCSUtil.concatenate(token, ltpa.getCreation());
        token = LMBCSUtil.concatenate(token, ltpa.getExpires());
        token = LMBCSUtil.concatenate(token, ltpa.getUser());
        md.update(token);
        byte[] digest = md.digest(BASE64Util.decodeAsBytes(properties.getProperty(DOMINO_SECRET)));
        ltpa.setDigest(digest);
        token = LMBCSUtil.concatenate(token, digest);
        String tokenStr = BASE64Util.encode(token);
        String result = "";
        StringTokenizer st = new StringTokenizer(tokenStr);
        while (st.hasMoreTokens()) {
            result = result + st.nextToken();
        }
        return new LtpaToken(result).toString();
    }

    private static boolean isValid(String ltpaToken) {
        if (!existSSOConfig) {
            return false;
        }
        LtpaToken ltpa = new LtpaToken(LtpaToken.decodeToken(ltpaToken));
        boolean result = ltpa.isValid(properties.getProperty(DOMINO_SECRET));
        System.out.println("LTPA token isValid result:" + result);
        if (!result) {
            System.out.println("LTPA token compare false, token:" + ltpaToken);
        }
        return result;
    }

    private static boolean compare(String token, String userNumber) {
        boolean result = false;
        LtpaToken lt = new LtpaToken(LtpaToken.decodeToken(token));
        String username = lt.getUsername();
        result = username == null ? false : username.equals(userNumber);
        logger.info((Object)("LTPA token compare result: " + result + " ; userName: " + userNumber));
        if (!result) {
            logger.info((Object)("LTPA token compare false, token: " + token + " ; userName: " + userNumber));
        }
        return result;
    }

    public static boolean verifyToken(String token, String userNumber) {
        boolean result = false;
        boolean isValid = LtpaTokenManager.isValid(LtpaToken.decodeToken(token));
        if (isValid) {
            result = LtpaTokenManager.compare(LtpaToken.decodeToken(token), userNumber);
            if (!result) {
                logger.info((Object)("LTPA token compare false, token: " + token + " ; userName: " + userNumber));
            }
        } else {
            logger.info((Object)("LTPA token isValid false, token: " + token + " ; userName: " + userNumber));
        }
        return result;
    }

    public static void main(String[] args) {
        String token = LtpaTokenManager.generate("18617110014");
        System.out.println(token);
        boolean result = LtpaTokenManager.verifyToken(token, "18617110014");
        System.out.println(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        Object object = lockObj = new Object();
        synchronized (object) {
            String tmp = System.getProperty("java.security.auth.login.config");
            if (tmp == null || tmp.lastIndexOf("/") < 0) {
                existSSOConfig = false;
                logger.error((Object)"System.getProperty('java.security.auth.login.config') \u9519\u8bef!");
            } else {
                int i = tmp.lastIndexOf("/");
                String CONFIG_DIR = tmp.substring(0, i) + "/ssc/eas/";
                String file = null;
                properties = new Properties();
                InputStream is = null;
                try {
                    file = CONFIG_DIR + "/LtpaToken.properties";
                    is = new FileInputStream(file);
                    properties.load(is);
                }
                catch (IOException ioe) {
                    existSSOConfig = false;
                    logger.error((Object)("LtpaToken.properties not found. file = " + file), (Throwable)ioe);
                }
                finally {
                    try {
                        if (is != null) {
                            is.close();
                        }
                    }
                    catch (IOException e) {
                        logger.error((Object)e);
                    }
                }
                if (null == properties.getProperty(DOMINO_SECRET) || null == properties.getProperty(TOKEN_EXPIRATION)) {
                    logger.error((Object)("LtpaToken.properties not configured properly. file = " + file));
                    existSSOConfig = false;
                }
            }
        }
    }
}

