/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.eip.sso.ldap;

import java.util.Properties;

public class LdapConfigInfo {
    private Properties configProps = new Properties();

    public Properties getConfigProps() {
        return this.configProps;
    }

    public void setConfigProps(Properties configProps) {
        this.configProps = configProps;
    }

    public String getContextFactory() {
        String propsValue = this.get("contextFactory");
        return this.get(propsValue, "com.sun.jndi.ldap.LdapCtxFactory");
    }

    public String get(String key, String defaultValue) {
        String propsValue = this.configProps.getProperty(key);
        return propsValue == null ? defaultValue : propsValue;
    }

    public String get(String key) {
        return this.configProps.getProperty(key);
    }

    public String getCredentials() {
        String propsValue = this.get("credentials");
        return this.get(propsValue, null);
    }

    public String getLdapHost() {
        return this.get("ldapHost", "localhost");
    }

    public int getLdapPort() {
        int ldapPort = 389;
        String port = this.get("ldapPort", new Integer(ldapPort).toString());
        try {
            ldapPort = Integer.parseInt(port);
        }
        catch (NumberFormatException e) {
            ldapPort = 389;
        }
        return ldapPort;
    }

    public String getPrincipal() {
        String propsValue = this.get("principal");
        return this.get(propsValue, null);
    }

    public String getProviderURL() {
        String protocal = this.get("protocal", "ldap");
        StringBuffer providerUrl = new StringBuffer(protocal + "://");
        providerUrl.append(this.getLdapHost());
        providerUrl.append(":");
        providerUrl.append(this.getLdapPort());
        return providerUrl.toString();
    }

    public String getAuthentication() {
        return this.get("authentication", null);
    }
}

