/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.eip.sso.ldap;

import com.kingdee.eas.cp.eip.sso.ldap.LdapConfigInfo;
import com.kingdee.eas.cp.eip.sso.util.ConfigUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class LdapConfigManager {
    private static String baseDir = ConfigUtil.getConfigFileBaseDir("W:/eas/Server/server/deploy/portalConfig/");
    private static String configFile = "ldapConfig.properties";
    private static LdapConfigInfo ldapConfigInfo = null;

    public static void load() {
        InputStream is = null;
        try {
            File configFileHandler = new File(baseDir, configFile);
            is = new FileInputStream(configFileHandler);
            Properties prop = new Properties();
            prop.load(is);
            ldapConfigInfo = new LdapConfigInfo();
            ldapConfigInfo.setConfigProps(prop);
        }
        catch (IOException e) {
            System.err.println("ldap Config file [" + configFile + "] load fail." + e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    System.err.println("ldap Config file [" + configFile + "] load fail." + e);
                }
            }
        }
    }

    public static LdapConfigInfo getLdapConfigInfo() {
        return ldapConfigInfo;
    }

    public static void setBaseDir(String baseDir) {
        LdapConfigManager.baseDir = baseDir;
    }

    public static void setConfigFile(String configFile) {
        LdapConfigManager.configFile = configFile;
    }

    static {
        if (ldapConfigInfo == null) {
            LdapConfigManager.load();
        }
    }
}

