/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.eip.sso.ldap;

import com.kingdee.eas.cp.eip.sso.ldap.LdapConfigInfo;
import com.kingdee.eas.cp.eip.sso.ldap.LdapConfigManager;
import com.kingdee.util.StringUtils;
import java.util.Hashtable;
import javax.naming.AuthenticationException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import org.apache.log4j.Logger;

public class LdapHelper {
    private static Logger logger = Logger.getLogger((String)LdapHelper.class.getName());
    private static LdapContext ctx = null;
    private static String BASEDN = null;

    private static void init() {
        try {
            LdapConfigInfo configInfo = LdapConfigManager.getLdapConfigInfo();
            Hashtable<String, String> env = new Hashtable<String, String>();
            env.put("java.naming.factory.initial", configInfo.getContextFactory());
            env.put("java.naming.provider.url", configInfo.getProviderURL());
            env.put("java.naming.security.authentication", configInfo.getAuthentication());
            BASEDN = configInfo.get("baseDN");
            String root = configInfo.get("principal");
            env.put("java.naming.security.principal", root);
            env.put("java.naming.security.credentials", configInfo.get("credentials"));
            ctx = new InitialLdapContext(env, null);
        }
        catch (AuthenticationException e) {
            logger.error((Object)"\u8fde\u63a5\u5931\u8d25\uff1a", (Throwable)e);
        }
        catch (Exception e) {
            logger.error((Object)"\u8fde\u63a5\u5931\u8d25\uff1a", (Throwable)e);
        }
    }

    private void closeContext() {
        if (ctx != null) {
            try {
                ctx.close();
            }
            catch (NamingException e) {
                e.printStackTrace();
            }
        }
    }

    public static String getUserDN(String uid) {
        if (ctx == null) {
            LdapHelper.init();
        }
        if (StringUtils.isEmpty((String)BASEDN)) {
            return null;
        }
        String userDN = null;
        try {
            SearchControls constraints = new SearchControls();
            constraints.setSearchScope(2);
            NamingEnumeration<SearchResult> en = ctx.search(BASEDN, "uid=" + uid, constraints);
            logger.info((Object)("BASEDN=" + BASEDN + ",UID=" + uid));
            if (en == null || !en.hasMoreElements()) {
                logger.error((Object)"\u4e0d\u5b58\u5728\u6b64\u7528\u6237");
                return null;
            }
            while (en != null && en.hasMoreElements()) {
                Object obj = en.nextElement();
                if (obj instanceof SearchResult) {
                    SearchResult si = (SearchResult)obj;
                    logger.info((Object)("\u8fd4\u56de\u641c\u7d22\u540d\u79f0\u7ed3\u679c\uff1a" + si.getName()));
                    logger.info((Object)("\u8fd4\u56de\u641c\u7d22\u5b8c\u6574\u4fe1\u606f\uff1a" + si.getAttributes().toString()));
                    userDN = si.getName() + "," + BASEDN;
                    continue;
                }
                logger.error((Object)("\u4e0d\u662f\u6807\u51c6\u7684\u8fd4\u56de\u7ed3\u679c\uff1a" + obj));
            }
        }
        catch (Exception e) {
            logger.error((Object)"\u67e5\u8be2\u51fa\u9519", (Throwable)e);
        }
        return userDN;
    }
}

