/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.eip.sso.ldapAdapter;

import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.cp.eip.sso.IUserSyncFacade;
import com.kingdee.eas.cp.eip.sso.IUserSyncHandleFacade;
import com.kingdee.eas.cp.eip.sso.UserSyncFacadeFactory;
import com.kingdee.eas.cp.eip.sso.UserSyncHandleFacadeFactory;
import com.kingdee.eas.cp.eip.sso.client.ListLF;
import com.kingdee.eas.cp.eip.sso.ldapAdapter.LdapExtendUtil;
import com.kingdee.eas.cp.eip.sso.ldapAdapter.LdapServerUtil;
import com.kingdee.eas.cp.eip.sso.special.DefaultOutputXml;
import com.kingdee.eas.tools.datatask.runtime.UploadFileToServerHelper;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.naming.NamingEnumeration;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchResult;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;

public class LdapClientUtil {
    private static LdapClientUtil ldapClientUtil = null;
    public static final String CANCEL_OPTION = "$CANCEL_OPTION$";

    private LdapClientUtil() {
    }

    public static LdapClientUtil init() {
        if (ldapClientUtil == null) {
            ldapClientUtil = new LdapClientUtil();
        }
        return ldapClientUtil;
    }

    public DefaultKingdeeTreeNode initDefaultKingdeeTreeNode(DirContext dirCtx, String dn, DefaultKingdeeTreeNode rootNode) throws Exception {
        NamingEnumeration namingEnum = LdapServerUtil.init().getNamingEnumeration(dirCtx, dn, null, null, LdapExtendUtil.DN_ATTR, 1);
        return this.initNode(dirCtx, namingEnum, rootNode);
    }

    public DefaultKingdeeTreeNode initNode(DirContext dirCtx, NamingEnumeration namingEnum, DefaultKingdeeTreeNode rootNode) throws Exception {
        SearchResult result = null;
        DefaultKingdeeTreeNode note = null;
        while (namingEnum.hasMore()) {
            result = (SearchResult)namingEnum.next();
            note = new DefaultKingdeeTreeNode();
            note.setText(result.getName());
            note.setUserObject((Object)result);
            rootNode.add((MutableTreeNode)note);
            String dn = this.getDN(note);
            try {
                note = this.initNode(dirCtx, LdapServerUtil.init().getNamingEnumeration(dirCtx, dn, null, null, LdapExtendUtil.DN_ATTR, 1), note);
            }
            catch (Exception exception) {}
        }
        return rootNode;
    }

    public static TreePath initTreePath(DefaultKingdeeTreeNode tmp) {
        String treePath = "";
        for (int j = 0; j < tmp.getPath().length; ++j) {
            treePath = StringUtils.isEmpty((String)treePath) ? tmp.getPath()[j].toString() : treePath + "," + tmp.getPath()[j].toString();
        }
        return new TreePath("[" + treePath + "]");
    }

    public void cleanTime(HashMap map, String id, String strtime) throws Exception {
        if (null != map && map.containsKey(id)) {
            IUserSyncHandleFacade iUser = UserSyncHandleFacadeFactory.getRemoteInstance();
            iUser.controlUserNode(LdapExtendUtil.init().setHashMap(map, id, strtime));
        }
    }

    public void sync(String id, HashMap map, IUIObject owner, Object object) throws Exception {
        boolean autoCreateUser = true;
        int answerInt = MsgBox.showConfirm3((Component)((Component)owner), (String)EASResource.getString((String)"com.kingdee.eas.cp.eip.sso.UserSyncResource", (String)"istongbu"));
        if (0 == answerInt) {
            autoCreateUser = true;
        } else if (1 == answerInt) {
            autoCreateUser = false;
        } else {
            return;
        }
        IUserSyncFacade iUserSyncCtrl = UserSyncFacadeFactory.getRemoteInstance();
        HashMap returnmap = null;
        try {
            returnmap = iUserSyncCtrl.runUserSync(id, autoCreateUser, object);
            if (returnmap != null) {
                this.afterSync(returnmap);
            }
        }
        catch (Exception e) {
            if (returnmap != null) {
                this.afterSync(returnmap);
            }
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.cp.eip.sso.UserSyncResource", (String)"tongbulost"));
        }
        SimpleDateFormat bartDateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
        Date date = new Date();
        String strtime = bartDateFormat.format(date);
        this.cleanTime(map, id, strtime);
    }

    public void afterSync(HashMap returnmap) throws Exception {
        int suc = 0;
        int lost = 0;
        if (returnmap != null) {
            suc = returnmap.get("success") == null ? 0 : Integer.parseInt(returnmap.get("success").toString()) + 1;
            lost = returnmap.get("lost") == null ? 0 : Integer.parseInt(returnmap.get("lost").toString()) + 1;
            this.afterSync(suc, lost);
        }
    }

    public void afterSync(int suc, int lost) throws Exception {
        StringBuffer strbuf = new StringBuffer();
        strbuf.append(EASResource.getString((String)"com.kingdee.eas.cp.eip.sso.UserSyncResource", (String)"phsuccess"));
        strbuf.append(" " + String.valueOf(suc) + " ");
        strbuf.append(EASResource.getString((String)"com.kingdee.eas.cp.eip.sso.UserSyncResource", (String)"phitem"));
        strbuf.append("\n");
        strbuf.append(EASResource.getString((String)"com.kingdee.eas.cp.eip.sso.UserSyncResource", (String)"phlost"));
        strbuf.append(" " + String.valueOf(lost) + " ");
        strbuf.append(EASResource.getString((String)"com.kingdee.eas.cp.eip.sso.UserSyncResource", (String)"phitem"));
        MsgBox.showInfo((String)strbuf.toString());
    }

    public String getListSelectID(KDTable table) {
        Iterator it;
        List list = ListLF.init().getSelctList((Object)table, "id");
        if (list.size() == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.cp.eip.sso.UserSyncResource", (String)"pleaseSelectRow"));
            return "";
        }
        String str = "";
        if (list.size() != 0 && (it = list.iterator()).hasNext()) {
            str = it.next().toString();
        }
        return str;
    }

    public String filePath(Component own, boolean isFile) {
        KDFileChooser fc = new KDFileChooser();
        if (isFile) {
            fc.setFileSelectionMode(0);
        } else {
            fc.setFileSelectionMode(1);
        }
        fc.setMultiSelectionEnabled(false);
        fc.setCurrentDirectory(null);
        fc.setAcceptAllFileFilterUsed(true);
        if (fc.showSaveDialog(own) == 1) {
            return CANCEL_OPTION;
        }
        if (fc.getSelectedFile() == null) {
            return "";
        }
        return fc.getSelectedFile().getPath();
    }

    public String importXML(String path) throws Exception {
        UploadFileToServerHelper uHelper = new UploadFileToServerHelper();
        return uHelper.uploadFile(path);
    }

    public void importXML() throws Exception {
        MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.cp.eip.sso.UserSyncResource", (String)"ldapimportlost"));
        MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.cp.eip.sso.UserSyncResource", (String)"ldapimportsuccess"));
    }

    public void exportXML(String path, Map map, String id) throws Exception {
        try {
            String str = UserSyncHandleFacadeFactory.getRemoteInstance().inputXML(map, id);
            DefaultOutputXml.init().inputXML(str, path);
            MsgBox.showInfo((String)(EASResource.getString((String)"com.kingdee.eas.cp.eip.sso.UserSyncResource", (String)"exportsuccess") + "\uff01"));
        }
        catch (Exception e) {
            MsgBox.showInfo((String)(EASResource.getString((String)"com.kingdee.eas.cp.eip.sso.UserSyncResource", (String)"exportlost") + "\uff01"));
        }
    }

    public final String getDN(DefaultKingdeeTreeNode treeNode) {
        StringBuffer dnbuffer = new StringBuffer("");
        if (treeNode != null) {
            if (treeNode.getUserObject() instanceof String) {
                dnbuffer.append(treeNode.getUserObject().toString());
            } else {
                SearchResult result = (SearchResult)treeNode.getUserObject();
                dnbuffer.append(result.getName());
            }
            if (!treeNode.isRoot()) {
                dnbuffer.append(",");
                dnbuffer.append(this.getDN((DefaultKingdeeTreeNode)treeNode.getParent()));
            }
        }
        return dnbuffer.toString();
    }
}

