/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.eip.sso.user;

import com.kingdee.eas.cp.eip.sso.user.AbstractConfigValidator;
import com.kingdee.eas.cp.eip.sso.user.UserResource;
import com.kingdee.eas.cp.eip.sso.user.UserSyncConfigItem;
import org.apache.log4j.Logger;

public class DbConfigValidator
extends AbstractConfigValidator {
    private Logger logger = Logger.getLogger((String)DbConfigValidator.class.getName());

    @Override
    public boolean validateUserSyncResource(UserResource ldapResx) {
        boolean result = true;
        if (DbConfigValidator.isEmpty(ldapResx.getJndiName())) {
            this.logger.debug((Object)("[Eas multi auth]user config file's database connect param[jndiName] is empty. " + ldapResx.toString()));
            result = false;
        }
        return result;
    }

    @Override
    public boolean checkFilter(UserSyncConfigItem configItem) {
        boolean result = true;
        String filter = configItem.getFilter();
        int first = filter.indexOf("?");
        if (first > -1) {
            if (filter.indexOf("?", first + 1) > -1) {
                result = true;
            } else {
                result = false;
                this.logger.debug((Object)("[Eas multi auth]user config file's userSyncConfigItem filter is invalid.filter=[" + filter + "],must have 2 params(?) in sql statement."));
            }
        } else {
            result = true;
        }
        return result;
    }

    @Override
    public boolean validateUserSyncConfigItem(UserSyncConfigItem configItem) {
        boolean result = super.validateUserSyncConfigItem(configItem);
        if (result) {
            result = this.checkFilter(configItem);
        }
        return result;
    }
}

