/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.eip.sso;

import com.kingdee.bos.Context;
import com.kingdee.bos.UserContextCallback;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.session.BOSLoginException;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.permission.Administrator;
import com.kingdee.eas.base.permission.LoginAuthorWayEnum;
import com.kingdee.eas.base.permission.UserException;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.app.PermissionLoginModule;
import com.kingdee.eas.base.uiframe.EASLoginException;
import com.kingdee.eas.base.uiframe.MainFrameServiceFacadeFactory;
import com.kingdee.eas.cp.eip.sso.EasMultiAuthManager;
import com.kingdee.eas.cp.eip.sso.IEasAuthHandler;
import com.kingdee.eas.cp.eip.sso.kdCloud.KingdeeCloudAuthHandler;
import com.kingdee.eas.cp.eip.sso.ltpa.LtpaTokenAuthHandler;
import com.kingdee.eas.cp.eip.sso.qrcode.QrCodeTokenAuthHandler;
import com.kingdee.eas.util.CryptException;
import com.kingdee.eas.util.CryptoTean;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import java.util.Locale;
import org.apache.log4j.Logger;

public class EasMultiAuthLoginModule
extends PermissionLoginModule {
    private static final Logger logger = Logger.getLogger(EasMultiAuthLoginModule.class);
    private IEasAuthHandler easAuthHandler;

    public String getEasUserNumber(Context ctx, String externalUserNumber) throws BOSLoginException {
        return this.easAuthHandler.getEasUserNumber(ctx, externalUserNumber);
    }

    public boolean isVerifyEasUserPwd() {
        return this.easAuthHandler.isVerifyEasUserPwd();
    }

    protected boolean verifyUserAndPassword(UserContextCallback userCtxCallback, String user, String pass) throws Exception {
        boolean result = false;
        userCtxCallback.setUserPK((IObjectPK)new ObjectUuidPK());
        this.easAuthHandler = this.getAuthHandler(userCtxCallback);
        logger.error((Object)("easAuthHandler ==" + this.easAuthHandler));
        Context ctx = userCtxCallback.getUserContext();
        String easUserNumber = this.getEasUserNumber(ctx, user);
        userCtxCallback.setUserName(easUserNumber);
        this._setUserPK(userCtxCallback, easUserNumber);
        try {
            UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
            boolean isSecurityAuthEnable = userInfo.getLoginAuthorWay() != null && !LoginAuthorWayEnum.NORMAL.equals((Object)userInfo.getLoginAuthorWay());
            boolean isLtpaTokenAuthn = this.easAuthHandler instanceof LtpaTokenAuthHandler;
            boolean isQrcodeTokenAuthn = this.easAuthHandler instanceof QrCodeTokenAuthHandler;
            boolean isKingdeeCloudAuth = this.easAuthHandler instanceof KingdeeCloudAuthHandler;
            if (!isSecurityAuthEnable || isLtpaTokenAuthn || isQrcodeTokenAuthn || isKingdeeCloudAuth) {
                String passTmp = EasMultiAuthLoginModule.decodePassword(user, pass);
                result = this.easAuthHandler.authenticate(userCtxCallback, user, passTmp);
                System.out.println("Eas Multi Auth result:" + result);
                if (!result) {
                    throw new EASLoginException(EASLoginException.AUTHFAILED, new Object[]{user});
                }
            }
            if (this.isVerifyEasUserPwd() || isSecurityAuthEnable && !isLtpaTokenAuthn && !isQrcodeTokenAuthn && !isKingdeeCloudAuth) {
                result = this._verifyUserAndPassword(userCtxCallback, easUserNumber, pass);
            }
            if (easUserNumber.indexOf("@") != -1) {
                this.checkUser(userInfo);
            } else {
                this.checkUser(userInfo);
            }
            if (!Administrator.isDefaultUser((BOSUuid)userInfo.getId())) {
                try {
                    MainFrameServiceFacadeFactory.getLocalInstance((Context)ctx).initUserLicenseInfoByCloud(null);
                }
                catch (UserException e) {
                    throw e;
                }
                catch (Exception e) {
                    logger.error((Object)"init user license from kingdee cloud failed", (Throwable)e);
                }
            }
            return result;
        }
        catch (Exception e) {
            String desc = ResourceBase.getString((String)"com.kingdee.eas.cp.eip.sso.web.auth.LoginFrameResxResource", (String)"login_error", (Locale)userCtxCallback.getUserContext().getLocale());
            LogUtil.beginLog((Context)userCtxCallback.getUserContext(), (String)"UserLogin", (BOSObjectType)new BOSObjectType("1DBFA8A7"), null, (String)(desc + ":" + this.getMessage(e, userCtxCallback.getUserContext().getLocale())));
            throw e;
        }
    }

    private void checkUser(UserInfo userInfo) throws Exception {
        if (userInfo.isIsForbidden()) {
            throw new UserException(UserException.USER_BEEN_FORBIDDEN);
        }
    }

    private IEasAuthHandler getAuthHandler(UserContextCallback userCtxCallback) {
        String authPattern = (String)userCtxCallback.getUserContext().get((Object)"UserAuthPattern");
        Object authHandler = null;
        if (EasMultiAuthManager.isApplicationScope() || authPattern == null || "".equals(authPattern)) {
            authPattern = EasMultiAuthManager.getDefaultAuthPattern().getName();
        }
        return EasMultiAuthManager.getAuthHandler(authPattern);
    }

    public static String decodePassword(String userName, String encodedPassword) {
        String password = "";
        try {
            password = encodedPassword == null || "".equals(encodedPassword) ? encodedPassword : CryptoTean.decrypt((String)userName, (String)encodedPassword);
        }
        catch (CryptException e) {
            logger.error((Object)"Passwod decode fails.");
        }
        return password;
    }

    private String getMessage(Exception ex, Locale locale) {
        Throwable ce = ex.getCause();
        if (ce != null) {
            if (ce instanceof UserException) {
                UserException ue = (UserException)ce;
                String str = ue.getMessage(locale);
                return str;
            }
            if (ce.getCause() instanceof UserException) {
                UserException ue = (UserException)ce.getCause();
                String str = ue.getMessage(locale);
                return str;
            }
            String str = ex.getCause().toString();
            return str.substring(str.lastIndexOf("Exception:") + 11, str.length());
        }
        return ex.getMessage();
    }
}

