/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.eip.sso.ad;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.UserContextCallback;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.framework.session.BOSLoginException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.eip.sso.AbstractEasAuthHandler;
import com.kingdee.eas.cp.eip.sso.External2EasUsersFacadeFactory;
import com.kingdee.eas.cp.eip.sso.UserPwdCallbackHandler;
import com.kingdee.eas.cp.eip.sso.util.PropertiesUtil;
import java.util.Properties;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.log4j.Logger;

public class ActiveDirAuthHandler
extends AbstractEasAuthHandler {
    private static Logger logger = Logger.getLogger((String)ActiveDirAuthHandler.class.getName());

    @Override
    public boolean authenticate(UserContextCallback userCtxCallback, String userNumber, String password) throws BOSLoginException {
        boolean result = false;
        LoginContext lc = null;
        String adRealmName = (String)userCtxCallback.getUserContext().get((Object)"adRealmName");
        if (adRealmName != null && adRealmName.length() > 0) {
            System.out.println("Find parameter adRealmName, it's value " + adRealmName);
            String krb5ConfigFileName = System.getProperty("eas.properties.dir") + "/" + adRealmName + ".conf";
            System.setProperty("java.security.krb5.conf", krb5ConfigFileName);
        }
        try {
            UserPwdCallbackHandler ch = new UserPwdCallbackHandler();
            ch.setUserId(userNumber);
            ch.setPasswords(password);
            lc = new LoginContext(ActiveDirAuthHandler.class.getName(), ch);
            lc.login();
            result = true;
        }
        catch (LoginException le) {
            System.err.println("[EAS Active Directory Auth ]Authentication attempt failed.\n" + le);
            return false;
        }
        return result;
    }

    @Override
    public String getEasUserNumber(Context ctx, String externalUserNumber) {
        String number = externalUserNumber;
        Properties prop = PropertiesUtil.getProperties(PropertiesUtil.getDefaultFullName("ssoClient.properties"));
        String isMapping = prop.getProperty("sso.user.mapping");
        if (isMapping != null && "true".equalsIgnoreCase(isMapping.trim())) {
            boolean isUseExternalUser = false;
            String isUseExternalUserStr = prop.getProperty("sso.user.useExternalUser");
            if (isUseExternalUserStr != null) {
                isUseExternalUser = "true".equalsIgnoreCase(isUseExternalUserStr.trim());
            }
            try {
                String easUserNumber = External2EasUsersFacadeFactory.getLocalInstance(ctx).getEasUsername(externalUserNumber, !isUseExternalUser);
                if (StringUtil.isEmptyString((String)easUserNumber)) {
                    easUserNumber = External2EasUsersFacadeFactory.getLocalInstance(ctx).getEasUsername(externalUserNumber, isUseExternalUser);
                }
                if (!StringUtil.isEmptyString((String)easUserNumber)) {
                    number = easUserNumber;
                }
            }
            catch (EASBizException e) {
                logger.info((Object)e);
            }
            catch (BOSException e) {
                logger.info((Object)e);
            }
        }
        return number;
    }
}

