/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.eip.sso.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.eip.sso.app.AbstractExternal2EasUsersFacadeControllerBean;
import com.kingdee.eas.cp.eip.sso.ldapAdapter.Eas2ExternalInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class External2EasUsersFacadeControllerBean
extends AbstractExternal2EasUsersFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)External2EasUsersFacadeControllerBean.class.getName());

    @Override
    protected String _getEasUsername(Context ctx, String externalUsername) throws BOSException, EASBizException {
        return this._getEasUsername(ctx, externalUsername, true);
    }

    @Override
    protected String _getEasUsername(Context ctx, String externalUsername, boolean isEasUser) throws BOSException, EASBizException {
        String result = externalUsername;
        Object[] excParam = new Object[]{"externalUsername"};
        if (externalUsername == null || "".equals(externalUsername)) {
            logger.debug((Object)"externalUsername is empty(null or '').");
            throw new EASBizException(EASBizException.CHECKBLANK, excParam);
        }
        String sqlStr = null;
        sqlStr = isEasUser ? " select fnumber from t_pm_user where ( UPPER(fnumber) = ? )" : " select feasusername,fexternalusername from T_SSO_External2EasUsers where ( UPPER(fexternalusername) = ? )";
        Object[] param = new Object[]{externalUsername.toUpperCase()};
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sqlStr, (Object[])param);
        try {
            if (rowSet == null || !rowSet.next()) {
                logger.debug((Object)("Eas is not exist this external user[" + externalUsername + "] map."));
                result = null;
            } else {
                result = isEasUser ? rowSet.getString("fnumber") : rowSet.getString("feasusername");
            }
        }
        catch (SQLException e) {
            logger.debug((Object)("getEasUsername fails.SQLException:" + e.toString()));
            throw new EASBizException(EASBizException.CHECKEXIST, (Throwable)e);
        }
        return result;
    }

    @Override
    protected String _getExternalUsername(Context ctx, String easUsername) throws BOSException, EASBizException {
        String result = easUsername;
        Object[] excParam = new Object[]{"easUsername"};
        if (easUsername == null || "".equals(easUsername)) {
            logger.debug((Object)"easUsername is empty(null or '').");
            throw new EASBizException(EASBizException.CHECKBLANK, excParam);
        }
        String sqlStr = " select FExternalUsername from T_SSO_External2EasUsers where ( FEasUsername = ? )";
        Object[] param = new Object[]{easUsername};
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sqlStr, (Object[])param);
        try {
            if (rowSet == null || !rowSet.next()) {
                logger.debug((Object)("Eas is not exist this  user[" + easUsername + "]'s external map."));
                result = null;
            } else {
                result = rowSet.getString("FExternalUsername");
            }
        }
        catch (SQLException e) {
            logger.debug((Object)("getExternalUsername fails.SQLException:" + e.toString()));
            e.printStackTrace();
            throw new EASBizException(EASBizException.CHECKEXIST, (Throwable)e);
        }
        return result;
    }

    protected List _getUser2External(Context ctx) throws BOSException {
        Eas2ExternalInfo info = null;
        ArrayList<Eas2ExternalInfo> ay = new ArrayList<Eas2ExternalInfo>();
        StringBuffer sb = new StringBuffer();
        sb.append("select p.fid,p.fnumber,p.fname_l2,e.fexternalusername,e.FExternalUserRealName,e.ffactpath_l2,e.fid from");
        sb.append(" t_pm_user as p");
        sb.append(" left join t_sso_ldapmapping AS l");
        sb.append(" on p.fid = l.Feasid");
        sb.append(" left join t_sso_external2easusers AS e");
        sb.append(" on l.fldapdn_l2 = e.ffactpath_l2");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        try {
            while (rowSet.next()) {
                info = new Eas2ExternalInfo();
                info.setEasid(rowSet.getString(1));
                info.setEasnumber(rowSet.getString(2));
                info.setEasname(rowSet.getString(3));
                info.setExternalnumber(rowSet.getString(4));
                info.setExternalname(rowSet.getString(5));
                info.setExternalpath(rowSet.getString(6));
                info.setExternalid(rowSet.getString(7));
                ay.add(info);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return ay;
    }
}

