/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.eip.sso.ldap;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.UserContextCallback;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.framework.session.BOSLoginException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.eip.sso.AbstractEasAuthHandler;
import com.kingdee.eas.cp.eip.sso.External2EasUsersFacadeFactory;
import com.kingdee.eas.cp.eip.sso.ldap.ILdapConnection;
import com.kingdee.eas.cp.eip.sso.ldap.LdapConnectionFactory;
import com.kingdee.eas.cp.eip.sso.util.PropertiesUtil;
import com.kingdee.util.StringUtils;
import java.util.Properties;
import javax.naming.NamingException;
import org.apache.log4j.Logger;

public class LdapAuthHandler
extends AbstractEasAuthHandler {
    private static Logger logger = Logger.getLogger((String)LdapAuthHandler.class.getName());

    @Override
    public boolean authenticate(UserContextCallback userCtxCallback, String userNumber, String password) throws BOSLoginException {
        if (password == null || StringUtils.isEmpty((String)password)) {
            return false;
        }
        ILdapConnection ldapConn = LdapConnectionFactory.create();
        logger.info((Object)("--------------userNumber::" + userNumber));
        boolean result = false;
        try {
            ldapConn.lookup(userNumber, password);
            result = true;
        }
        catch (NamingException e) {
            logger.error((Object)e);
            result = false;
        }
        return result;
    }

    @Override
    public String getEasUserNumber(Context ctx, String externalUserNumber) {
        String number = externalUserNumber;
        Properties prop = PropertiesUtil.getProperties(PropertiesUtil.getDefaultFullName("ssoClient.properties"));
        String isMapping = prop.getProperty("sso.user.mapping");
        if (isMapping != null && "true".equalsIgnoreCase(isMapping.trim())) {
            boolean isUseExternalUser = false;
            String isUseExternalUserStr = prop.getProperty("sso.user.useExternalUser");
            if (isUseExternalUserStr != null) {
                isUseExternalUser = "true".equalsIgnoreCase(isUseExternalUserStr.trim());
            }
            try {
                String easUserNumber = External2EasUsersFacadeFactory.getLocalInstance(ctx).getEasUsername(externalUserNumber, !isUseExternalUser);
                if (StringUtil.isEmptyString((String)easUserNumber)) {
                    easUserNumber = External2EasUsersFacadeFactory.getLocalInstance(ctx).getEasUsername(externalUserNumber, isUseExternalUser);
                }
                if (!StringUtil.isEmptyString((String)easUserNumber)) {
                    number = easUserNumber;
                }
            }
            catch (EASBizException e) {
                logger.info((Object)e);
            }
            catch (BOSException e) {
                logger.info((Object)e);
            }
        }
        return number;
    }
}

