/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.eip.sso.ldap;

import com.kingdee.eas.cp.eip.sso.ldap.ILdapConnection;
import com.kingdee.eas.cp.eip.sso.ldap.LdapConfigInfo;
import com.kingdee.eas.cp.eip.sso.user.PasswordUtils;
import java.util.Hashtable;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import org.apache.log4j.Logger;

public class LdapConnection
implements ILdapConnection {
    private LdapConfigInfo configInfo = null;
    private static Logger logger = Logger.getLogger((String)LdapConnection.class.getName());

    public LdapConnection(LdapConfigInfo configInfo) {
        this.configInfo = configInfo;
    }

    @Override
    public DirContext lookup(String username, String password) throws NamingException {
        String flagStr;
        Hashtable env = this.prepareContext();
        env.put("java.naming.security.principal", username);
        String pwd = password;
        if (pwd != null && pwd.startsWith(flagStr = "encrypt:")) {
            int idx = flagStr.length();
            pwd = pwd.substring(idx);
            pwd = PasswordUtils.decodePassword(this.configInfo.getPrincipal(), pwd);
        }
        env.put("java.naming.security.credentials", pwd);
        logger.debug((Object)env.toString());
        InitialDirContext dirCtx = new InitialDirContext(env);
        return dirCtx;
    }

    @Override
    public DirContext lookup() throws NamingException {
        DirContext dirCtx = this.lookup(this.configInfo.getPrincipal(), this.configInfo.getCredentials());
        return dirCtx;
    }

    private Hashtable prepareContext() {
        Hashtable<String, String> env = new Hashtable<String, String>(5);
        env.put("java.naming.factory.initial", this.configInfo.getContextFactory());
        String url = this.configInfo.getProviderURL();
        env.put("java.naming.provider.url", url);
        if (url.startsWith("ldaps://")) {
            env.put("java.naming.security.protocol", "ssl");
            env.put("java.naming.ldap.factory.socket", "com.kingdee.eas.cp.eip.sso.ldap.LdapSSLSocketFactory");
        }
        env.put("java.naming.security.authentication", this.configInfo.getAuthentication());
        return env;
    }

    @Override
    public void close(DirContext dirCtx) {
        if (dirCtx != null) {
            try {
                dirCtx.close();
                dirCtx = null;
            }
            catch (NamingException e) {
                e.printStackTrace();
            }
        }
    }
}

