/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.eip.sso.ldapAdapter;

import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.cp.eip.sso.ldapAdapter.LdapExtendUtil;
import com.kingdee.eas.cp.eip.sso.special.DefaultOutputXml;
import com.kingdee.eas.cp.eip.sso.user.PasswordUtils;
import com.kingdee.eas.cp.eip.sso.user.UserResource;
import com.kingdee.eas.cp.eip.sso.user.UserSyncConfigItem;
import com.kingdee.util.StringUtils;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.apache.log4j.Logger;

public class LdapServerUtil {
    private static LdapServerUtil ldapControlUtil = null;
    private static final Logger logger = CoreUIObject.getLogger(LdapServerUtil.class);

    private LdapServerUtil() {
    }

    public static LdapServerUtil init() {
        if (ldapControlUtil == null) {
            ldapControlUtil = new LdapServerUtil();
        }
        return ldapControlUtil;
    }

    public Map getDNResource(NamingEnumeration namingEnum) throws Exception {
        SearchResult result = null;
        String temp2 = "";
        String temp1 = "";
        String temp = "";
        String tempKey = "";
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            if (namingEnum == null) {
                return null;
            }
            while (namingEnum.hasMore()) {
                result = (SearchResult)namingEnum.next();
                String valueStr = result.toString();
                StringTokenizer st = new StringTokenizer(valueStr, ":");
                while (st.hasMoreElements()) {
                    temp = st.nextToken();
                    if (temp.indexOf("=") == -1 && temp.indexOf("}") == -1) continue;
                    temp2 = temp.substring(0, temp.lastIndexOf(",") + 1);
                    if (!StringUtils.isEmpty((String)temp2)) {
                        map.put(tempKey, temp2.substring(0, temp2.length() - 1).trim());
                    }
                    if (!StringUtils.isEmpty((String)(temp2 = temp.substring(0, temp.lastIndexOf("}") + 1)))) {
                        map.put(tempKey, temp2.substring(0, temp2.length() - 1).trim());
                        continue;
                    }
                    temp1 = temp.substring(temp.lastIndexOf(",") + 1, temp.length());
                    if (StringUtils.isEmpty((String)(temp1 = temp1.substring(temp1.indexOf("=") + 1, temp1.length())))) continue;
                    tempKey = temp1.trim();
                    map.put(tempKey, "");
                }
            }
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        return map;
    }

    public InitialDirContext initContext(String url, String user, String pwd) throws Exception {
        InitialDirContext dirCtx = null;
        Hashtable<String, String> env = new Hashtable<String, String>(5);
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", url);
        env.put("java.naming.security.authentication", "simple");
        env.put("java.naming.security.principal", user);
        env.put("java.naming.security.credentials", pwd);
        dirCtx = new InitialDirContext(env);
        if (dirCtx == null) {
            throw new Exception("create ldap context error!");
        }
        return dirCtx;
    }

    public InitialDirContext initContext(UserResource ur) throws Exception {
        String flagStr;
        String pwd = "";
        pwd = ur.getCredentials();
        if (pwd != null && pwd.startsWith(flagStr = "encrypt:")) {
            int idx = flagStr.length();
            pwd = pwd.substring(idx);
            pwd = PasswordUtils.decodePassword(ur.getPrincipal(), pwd);
        }
        return LdapServerUtil.init().initContext(ur.getProviderURL(), ur.getPrincipal(), pwd);
    }

    public NamingEnumeration getNamingEnumeration(DirContext dirCtx, String dn, String filterExp, Object[] filterParam, String[] attr, int scope) throws Exception {
        SearchControls constraints = new SearchControls();
        constraints.setSearchScope(scope);
        if (attr == null) {
            attr = LdapExtendUtil.DEFAULT_ATTR;
        }
        if (attr.length != 0) {
            constraints.setReturningAttributes(attr);
        }
        try {
            if (StringUtils.isEmpty((String)filterExp)) {
                return dirCtx.search(dn, "(objectclass=*)", constraints);
            }
            if (filterParam.length == 0) {
                return dirCtx.search(dn.trim(), filterExp.trim(), constraints);
            }
            return dirCtx.search(dn.trim(), filterExp.trim(), filterParam, constraints);
        }
        catch (NamingException e) {
            return null;
        }
    }

    public String importXML(Map map, String id) throws Exception {
        Iterator it = null;
        Map.Entry entry2 = null;
        SearchResult result = null;
        UserSyncConfigItem usci = null;
        NamingEnumeration namingEnum = null;
        String filter = "";
        String dn = "";
        String[] atts = new String[]{};
        HashMap<String, Map> valueMap = new HashMap<String, Map>();
        HashMap<String, String> dnMap = new HashMap<String, String>();
        UserResource ur = (UserResource)map.get(id);
        InitialDirContext dirCtx = LdapServerUtil.init().initContext(ur);
        for (Map.Entry entry2 : ur.getUserSyncConfigItemMap().entrySet()) {
            usci = (UserSyncConfigItem)entry2.getValue();
            filter = usci.getFilter();
            Object[] filterParam = LdapExtendUtil.init().getFilterParams(usci);
            namingEnum = LdapServerUtil.init().getNamingEnumeration(dirCtx, LdapExtendUtil.init().updateDN(usci.getBaseDN()), filter, filterParam, LdapExtendUtil.DN_ATTR, 2);
            try {
                if (namingEnum == null) continue;
                while (namingEnum.hasMore()) {
                    result = (SearchResult)namingEnum.next();
                    dnMap.put(LdapExtendUtil.init().updateDN(result.getAttributes().get("distinguishedName").toString()), "");
                }
            }
            catch (NamingException namingException) {
                // empty catch block
            }
            if (!StringUtils.isEmpty((String)usci.getReturningAttributes())) {
                atts = LdapExtendUtil.init().string2Atts(usci.getReturningAttributes());
                continue;
            }
            atts = LdapExtendUtil.DEFAULT_ATTR;
        }
        for (Map.Entry entry2 : dnMap.entrySet()) {
            dn = entry2.getKey().toString();
            logger.info((Object)("write " + dn + " in xml"));
            valueMap.put(dn, LdapServerUtil.init().getDNResource(this.getNamingEnumeration(dirCtx, dn, null, null, atts, 0)));
        }
        return DefaultOutputXml.init().initString(valueMap);
    }

    public String getPath(String fileName) {
        try {
            System.getProperty("portal.config");
        }
        catch (Exception e) {
            logger.info((Object)("LdapDNConfigManager System getProperty error " + e));
        }
        if (System.getProperty("portal.config") == null) {
            logger.info((Object)"LdapDNConfigManager System getProperty is null ");
        } else if (System.getProperty("portal.config").length() == 0) {
            logger.info((Object)"LdapDNConfigManager System getProperty is null ");
        }
        String portalStr = System.getProperty("portal.config");
        String str1 = "portalConfig.xml";
        String interStr = portalStr.substring(0, portalStr.length() - str1.length());
        String path = interStr + fileName;
        return path;
    }
}

