/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.eip.sso.util;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.common.DCInfo;
import com.kingdee.eas.base.license.CloudRegistSrvAgentFactory;
import com.kingdee.eas.base.license.ILicenseSrv;
import com.kingdee.eas.base.license.LicenseBaseInfo;
import com.kingdee.eas.base.license.agent.LicenseSrvFactory;
import com.kingdee.eas.base.license.file.cloudRegist.CloudRegistUserInfo;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.log.LoginAndLogout;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.app.util.UserInfoUtils;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.common.web.util.DataCenterManager;
import com.kingdee.eas.cp.eip.sso.CloudParamFactory;
import com.kingdee.eas.cp.eip.sso.CloudParamInfo;
import com.kingdee.eas.cp.eip.sso.ICloudParam;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudParamUtil {
    private static Logger logger = LoggerFactory.getLogger(CloudParamUtil.class);
    private static final String RESOURCE = "com.kingdee.eas.cp.eip.sso.web.auth.LoginFrameResxResource";

    public static Map<String, String> getCloudParams(Context ctx) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        try {
            ILicenseSrv agent = LicenseSrvFactory.getInstance();
            LicenseBaseInfo baseInfo = agent.getLicenseBaseInfo();
            paramMap.put("prod_inst_code", baseInfo.getProductInstanceID());
            paramMap.put("productId", baseInfo.getProductID());
            CloudRegistUserInfo crui = CloudRegistSrvAgentFactory.getLocalInstance((Context)ctx).getCloudRegistUserInfo(ctx.getUserName());
            if (crui != null) {
                paramMap.put("uid", crui.getCloudUuId());
                paramMap.put("wholePhone", crui.getPhone());
                paramMap.put("mixPhone", CloudRegistSrvAgentFactory.getLocalInstance((Context)ctx).getErpTelephone(ctx.getUserName()));
            } else {
                paramMap.put("uid", "");
                paramMap.put("wholePhone", "");
                paramMap.put("mixPhone", "");
            }
        }
        catch (Exception e) {
            logger.error("getCloudParams error===", (Throwable)e);
        }
        return paramMap;
    }

    public static Context getContext(String dataCenter, String language, String userName) {
        Context context = new Context();
        Context userCtx = new Context();
        Locale locale = new Locale(CloudParamUtil.transferLanguage(language));
        userCtx.setLocale(locale);
        DataCenterManager dc = new DataCenterManager(userCtx);
        ArrayList dcList = dc.getDCList();
        for (DCInfo di : dcList) {
            if (!dataCenter.equals(di.getNumber())) continue;
            context.setAIS(dataCenter);
            String clientHostIP = "127.0.0.1";
            context.setClientHostIP(clientHostIP);
            context.setClientHostName(clientHostIP);
            context.setLocale(locale);
            context.setUserName(userName);
        }
        return context;
    }

    public static String transferLanguage(String language) {
        String lg = "";
        lg = "ch".equals(language) || "L2".equals(language) || "l2".equals(language) ? "l2" : ("tw".equals(language) || "L3".equals(language) || "l3".equals(language) ? "l3" : "l1");
        return lg;
    }

    public static String getOffineActivePhone(Context ctx) throws Exception {
        try {
            ICloudParam instance = CloudParamFactory.getLocalInstance(ctx);
            CoreBaseCollection coll = instance.getCollection("where key='OffineActivePhone'");
            if (coll.size() > 0) {
                CloudParamInfo info = (CloudParamInfo)coll.get(0);
                return info.getValue();
            }
        }
        catch (Exception e) {
            logger.error("get OffineActivePhone from table failed ", (Throwable)e);
        }
        return "10691719741876";
    }

    public static boolean checkXss(String param) {
        if (StringUtils.isEmpty((String)param)) {
            return true;
        }
        String[] invalidParams = new String[]{"./", "../", "\\", "*", "\"", "<", ">", "|"};
        for (int i = 0; i < invalidParams.length; ++i) {
            if (param.indexOf(invalidParams[i]) == -1) continue;
            return false;
        }
        return true;
    }

    public static boolean isIP(String addr) {
        if (addr.length() < 7 || addr.length() > 15 || "".equals(addr)) {
            return false;
        }
        String rexp = "([1-9]|[1-9]\\d|1\\d{2}|2[0-4]\\d|25[0-5])(\\.(\\d|[1-9]\\d|1\\d{2}|2[0-4]\\d|25[0-5])){3}";
        Pattern pat = Pattern.compile(rexp);
        Matcher mat = pat.matcher(addr);
        return mat.find();
    }

    public static void logGetAuthCode(Context userCtx) {
        try {
            String logMethod = ResourceBase.getString((String)RESOURCE, (String)"log_getAuthCode", (Locale)userCtx.getLocale());
            CloudParamUtil.addInfoToLog(userCtx, logMethod);
        }
        catch (Exception e) {
            logger.error("Add logGetAuthCode log error:", (Throwable)e);
        }
    }

    public static void logActiveSuccess(Context userCtx) {
        try {
            String logMethod = ResourceBase.getString((String)RESOURCE, (String)"log_active", (Locale)userCtx.getLocale());
            CloudParamUtil.addInfoToLog(userCtx, logMethod);
        }
        catch (Exception e) {
            logger.error("Add logActiveSuccess log error:", (Throwable)e);
        }
    }

    public static void logGetFindPasswordCode(Context userCtx) {
        try {
            String logMethod = ResourceBase.getString((String)RESOURCE, (String)"log_getCodeFindPass", (Locale)userCtx.getLocale());
            CloudParamUtil.addInfoToLog(userCtx, logMethod);
        }
        catch (Exception e) {
            logger.error("Add logGetFindPasswordCode log error:", (Throwable)e);
        }
    }

    public static void logFindPass(Context userCtx) {
        try {
            String logMethod = ResourceBase.getString((String)RESOURCE, (String)"log_findPass", (Locale)userCtx.getLocale());
            CloudParamUtil.addInfoToLog(userCtx, logMethod);
        }
        catch (Exception e) {
            logger.error("Add logFindPass log error:", (Throwable)e);
        }
    }

    private static void addInfoToLog(Context userCtx, String logMethod) throws EASBizException {
        UserInfo userInfo4LoinModule = null;
        if (userCtx.get((Object)"UserInfo") == null) {
            userInfo4LoinModule = UserInfoUtils.getUserInfo4LoinModule((Context)userCtx, (String)userCtx.getUserName());
            ContextUtil.setCurrentUserInfo((Context)userCtx, (UserInfo)userInfo4LoinModule);
        }
        if (ContextUtil.getCurrentCtrlUnit((Context)userCtx) == null) {
            if (userInfo4LoinModule == null) {
                userInfo4LoinModule = UserInfoUtils.getUserInfo4LoinModule((Context)userCtx, (String)userCtx.getUserName());
            }
            ContextUtil.setCurrentCtrlUnit((Context)userCtx, (CtrlUnitInfo)userInfo4LoinModule.getCU());
        }
        IObjectPK logPK = LogUtil.beginLog((Context)userCtx, (String)logMethod, (BOSObjectType)new LoginAndLogout().getType(), null, (String)logMethod, (String)"UserLoginLog");
        LogUtil.afterLog((Context)userCtx, (IObjectPK)logPK);
    }
}

