/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.eip.sso.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.eip.sso.ldapAdapter.ILdapUserSyncListener;
import com.kingdee.util.StringUtils;
import com.kingdee.util.UuidException;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class UserStateListener
implements ILdapUserSyncListener {
    private static Logger logger = Logger.getLogger((String)UserStateListener.class.getName());

    @Override
    public void userSyncListener(Context ctx, HashMap context) {
        try {
            IUser iu = UserFactory.getLocalInstance((Context)ctx);
            String userState = "";
            String userName = "";
            if (context == null) {
                return;
            }
            userState = context.get("userState") == null ? "0" : context.get("userState").toString();
            if (context.get("easUsername") == null) {
                return;
            }
            userName = context.get("easUsername").toString();
            UserInfo userInfo = iu.getUser(userName);
            if (userInfo == null) {
                return;
            }
            IObjectPK[] pk = new IObjectPK[]{new ObjectUuidPK(BOSUuid.read((String)userInfo.getId().toString()))};
            if (StringUtils.isEmpty((String)userState)) {
                iu.forbidUsers(pk, true);
            } else if (userState.equals("1")) {
                iu.forbidUsers(pk, false);
            } else {
                iu.forbidUsers(pk, true);
            }
        }
        catch (EASBizException e) {
            logger.info((Object)e);
        }
        catch (BOSException e) {
            logger.info((Object)e);
        }
        catch (UuidException e) {
            logger.info((Object)e);
        }
    }
}

