/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.eip.sso.web;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.eas.base.permission.Administrator;
import com.kingdee.eas.base.uiframe.GlobleLoginException;
import com.kingdee.eas.base.uiframe.globlelogin.GlobleLoginConfigFactory;
import com.kingdee.eas.base.uiframe.globlelogin.GlobleLoginConfigInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.common.web.util.WebContextUtil;
import com.kingdee.eas.cp.eip.sso.web.UserNameDecodeFilter;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.io.IOException;
import java.sql.SQLException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlobleLoginConfigServlet
extends HttpServlet {
    private static final Logger logger = LoggerFactory.getLogger(GlobleLoginConfigServlet.class);
    private static final long serialVersionUID = 1L;
    private ServletContext context = null;

    public void init(ServletConfig config) throws ServletException {
        this.context = config.getServletContext();
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        JSONObject result = new JSONObject();
        result.put((Object)"success", (Object)false);
        String loginType = request.getParameter("loginType");
        String dd_appId = request.getParameter("dd_appId");
        String dd_secret = request.getParameter("dd_secret");
        String dd_tokenUrl = request.getParameter("dd_tokenUrl");
        String appId = request.getParameter("appId");
        String secret = request.getParameter("secret");
        String authUrl = request.getParameter("authUrl");
        String openIdUrl = request.getParameter("openIdUrl");
        String qrcodeUrl = request.getParameter("qrcodeUrl");
        String callBackUrl = request.getParameter("callBackUrl");
        String privacyStatement = request.getParameter("privacyStatement");
        String portalEnabledQrcode = request.getParameter("portalEnabledQrcode");
        int authType = Integer.parseInt(StringUtils.isEmpty((String)request.getParameter("authType")) ? "0" : request.getParameter("authType"));
        int errNum = Integer.parseInt(StringUtils.isEmpty((String)request.getParameter("errNum")) ? "0" : request.getParameter("errNum"));
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        GlobleLoginConfigInfo info = new GlobleLoginConfigInfo();
        info.setDefaultLogin(loginType);
        info.setAppId(appId);
        if (!StringUtils.isEmpty((String)secret)) {
            try {
                secret = UserNameDecodeFilter.decrypt(secret);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            info.setSecret(secret);
        }
        info.setDd_appId(dd_appId);
        info.setDd_secret(dd_secret);
        info.setDd_tokenUrl(dd_tokenUrl);
        info.setAuthURL(authUrl);
        info.setOpenIdUrl(openIdUrl);
        info.setQrcodeUrl(qrcodeUrl);
        info.setCallBackUrl(callBackUrl);
        info.setAuthType(authType);
        info.setErrNum(errNum);
        info.setPortalEnableQrcode(Boolean.parseBoolean(portalEnabledQrcode));
        info.setPrivacyStatement(privacyStatement);
        try {
            if (ctx == null || !Administrator.isSuperCUAdmin((IObjectPK)ctx.getCaller())) {
                result.put((Object)"errorInfo", (Object)"permission error");
            } else if ("2".equalsIgnoreCase(privacyStatement)) {
                if (this.isEnablePrivacyStatement(ctx)) {
                    GlobleLoginConfigFactory.getLocalInstance((Context)ctx).saveConfig(ctx, info);
                    result.put((Object)"success", (Object)true);
                } else {
                    result.put((Object)"errorInfo", (Object)"\u4fdd\u5b58\u5931\u8d25\uff0c\u6ca1\u6709\u542f\u7528\u81ea\u5b9a\u4e49\u9690\u79c1\u58f0\u660e\uff01");
                }
            } else {
                GlobleLoginConfigFactory.getLocalInstance((Context)ctx).saveConfig(ctx, info);
                result.put((Object)"success", (Object)true);
            }
        }
        catch (EASBizException e) {
            e.printStackTrace();
            if (e instanceof GlobleLoginException) {
                GlobleLoginException ex = (GlobleLoginException)e;
                result.put((Object)"errorInfo", (Object)ex.getMessage());
            } else {
                result.put((Object)"errorInfo", (Object)GlobleLoginException.SYSTEMERROR.getName());
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
            result.put((Object)"errorInfo", (Object)GlobleLoginException.SYSTEMERROR.getName());
        }
        this.writeResponse(response, result.toString());
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    private void writeResponse(HttpServletResponse response, String result) {
        try {
            response.setContentType("text/html");
            response.getOutputStream().write(result.toString().getBytes("utf-8"));
        }
        catch (Exception ex) {
            logger.error("\u4e0d\u80fd\u5199\u6570\u636e\u3002\u5f02\u5e38\u5982\u4e0b\uff1a{}", (Throwable)ex);
        }
    }

    private boolean isEnablePrivacyStatement(Context ctx) {
        StringBuilder sql = new StringBuilder("SELECT FId FROM T_MY_PrivacyStatementCustom ");
        sql.append(" WHERE FStatus='ENABLE' AND FId <> 'Bjf/+yTQQsGuLPXnEjSKvTmwZE1=' ");
        try {
            IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (iRowSet != null && iRowSet.next()) {
                return true;
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return false;
    }
}

