/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.eip.sso.web.qrcode;

import com.kingdee.bos.Context;
import com.kingdee.eas.cp.eip.sso.qrcode.QrCodeServiceFactory;
import com.kingdee.eas.cp.eip.sso.qrcode.QrTokenOpenIdManager;
import com.kingdee.eas.cp.eip.sso.qrcode.exception.AppAuth2Exception;
import com.kingdee.eas.cp.eip.sso.web.qrcode.ResponseWriteUtil;
import com.kingdee.util.StringUtils;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YZJCallbackServlet
extends HttpServlet {
    private static final long serialVersionUID = 1426489082732035281L;
    private static final Logger logger = LoggerFactory.getLogger(YZJCallbackServlet.class);

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doPost(req, resp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        logger.error("YZJCallbackServlet  start-----------------");
        String ticket = req.getParameter("ticket");
        String token = req.getParameter("token");
        Context ctx = this.parseRestUrl(req);
        logger.error("YZJCallbackServlet  ticket=======" + ticket + "      token=====" + token);
        if (StringUtils.isEmpty((String)ticket) || StringUtils.isEmpty((String)token)) {
            logger.error("ticket : {}  or token : {}   is null", (Object)ticket, (Object)token);
            ResponseWriteUtil.writeAjaxData(resp, false, "400", "ticket or token is null");
            return;
        }
        try {
            QrCodeServiceFactory.create().callbackForTicket(ctx, ticket, token);
        }
        catch (AppAuth2Exception e) {
            e.printStackTrace();
        }
        finally {
            ResponseWriteUtil.writeAjaxData(resp, true, null, null);
        }
    }

    private Context parseRestUrl(HttpServletRequest req) throws ServletException {
        String restUrl = req.getRequestURL().toString();
        if (StringUtils.isEmpty((String)restUrl)) {
            logger.error("Call Back Parameters : DataCenter and  Local not found");
            throw new ServletException("Invalid Request URL : Call Back Parameters Database and Language not found");
        }
        Context ctx = null;
        String match = "Servlet/";
        try {
            int index = restUrl.indexOf(match);
            if (index != -1) {
                String params = restUrl.substring(index + match.length());
                String[] paramsArray = params.split("/");
                String dataCenter = paramsArray[0];
                String language = paramsArray[1];
                ctx = QrTokenOpenIdManager.getContext(dataCenter, language);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            throw new ServletException(e.getCause());
        }
        return ctx;
    }
}

