/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.eip.sso.web.cache.resource;

import com.kingdee.eas.cp.eip.sso.web.cache.SSOCacheResource;
import com.kingdee.eas.cp.eip.sso.web.cache.resource.ISSODirContext;
import com.kingdee.eas.cp.eip.sso.web.cache.resource.SSOBaseDirContext;
import com.kingdee.eas.cp.eip.sso.web.cache.resource.SSOFileResourceAttributes;
import com.kingdee.eas.cp.eip.sso.web.cache.resource.SSONamingEntry;
import com.kingdee.eas.cp.eip.sso.web.cache.resource.SSOResource;
import com.kingdee.eas.cp.eip.sso.web.cache.resource.SSOResourceAttributes;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.naming.NamingException;

public class SSOFileDirContext
extends SSOBaseDirContext {
    protected static final int BUFFER_SIZE = 2048;
    protected File base = null;
    protected String absoluteBase = null;
    protected boolean caseSensitive = true;
    protected boolean allowLinking = false;

    @Override
    public void setDocBase(String docBase) {
        if (docBase == null) {
            throw new IllegalArgumentException("doc Base is null.");
        }
        this.base = new File(docBase);
        try {
            this.base = this.base.getCanonicalFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (!(this.base.exists() && this.base.isDirectory() && this.base.canRead())) {
            throw new IllegalArgumentException("base file is not findor readonly.");
        }
        this.absoluteBase = this.base.getAbsolutePath();
        super.setDocBase(docBase);
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public void setAllowLinking(boolean allowLinking) {
        this.allowLinking = allowLinking;
    }

    public boolean getAllowLinking() {
        return this.allowLinking;
    }

    @Override
    public void release() {
        this.caseSensitive = true;
        this.allowLinking = false;
        this.absoluteBase = null;
        this.base = null;
        super.release();
    }

    @Override
    public Object lookup(String name) throws NamingException {
        Object result = null;
        File file = this.file(name);
        if (file == null) {
            throw new NamingException("file is null.");
        }
        if (file.isDirectory()) {
            SSOFileDirContext tempContext = new SSOFileDirContext();
            tempContext.setDocBase(file.getPath());
            tempContext.setAllowLinking(this.getAllowLinking());
            tempContext.setCaseSensitive(this.isCaseSensitive());
            result = tempContext;
        } else {
            result = new FileResource(file);
        }
        return result;
    }

    @Override
    public void unbind(String name) throws NamingException {
        File file = this.file(name);
        if (file == null) {
            throw new NamingException("file is null");
        }
        if (!file.delete()) {
            throw new NamingException("delete failed");
        }
    }

    public void rename(String oldName, String newName) throws NamingException {
        File file = this.file(oldName);
        if (file == null) {
            throw new NamingException("rename error.");
        }
        File newFile = new File(this.base, newName);
        file.renameTo(newFile);
    }

    @Override
    public SSOResourceAttributes getAttributes(String name) throws NamingException {
        File file = this.file(name);
        if (file == null) {
            throw new NamingException(name + " file is null");
        }
        return new SSOFileResourceAttributes(file);
    }

    @Override
    public void bind(String name, Object obj) throws NamingException {
        File file = new File(this.base, name);
        if (file.exists()) {
            throw new NamingException("file is exists.");
        }
        this.rebind(name, obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rebind(String name, Object obj) throws NamingException {
        File file = new File(this.base, name);
        InputStream is = null;
        if (obj instanceof SSOResource) {
            try {
                is = ((SSOResource)obj).streamContent();
            }
            catch (IOException iOException) {}
        } else if (obj instanceof InputStream) {
            is = (InputStream)obj;
        } else if (obj instanceof ISSODirContext) {
            if (file.exists() && !file.delete()) {
                throw new NamingException("fiel delete error.");
            }
            if (!file.mkdir()) {
                throw new NamingException("mkdir error.");
            }
        }
        if (is == null) {
            throw new NamingException("inputstread is null");
        }
        try {
            FileOutputStream os = null;
            byte[] buffer = new byte[2048];
            int len = -1;
            try {
                os = new FileOutputStream(file);
                while ((len = is.read(buffer)) != -1) {
                    os.write(buffer, 0, len);
                }
            }
            finally {
                if (os != null) {
                    os.close();
                }
                is.close();
            }
        }
        catch (IOException e) {
            throw new NamingException("rebind error.");
        }
    }

    protected String normalize(String path) {
        int index;
        String normalized = path;
        if (File.separatorChar == '\\' && normalized.indexOf(92) >= 0) {
            normalized = normalized.replace('\\', '/');
        }
        if (!normalized.startsWith("/")) {
            normalized = "/" + normalized;
        }
        while ((index = normalized.indexOf("//")) >= 0) {
            normalized = normalized.substring(0, index) + normalized.substring(index + 1);
        }
        while ((index = normalized.indexOf("/./")) >= 0) {
            normalized = normalized.substring(0, index) + normalized.substring(index + 2);
        }
        while ((index = normalized.indexOf("/../")) >= 0) {
            if (index == 0) {
                return null;
            }
            int index2 = normalized.lastIndexOf(47, index - 1);
            normalized = normalized.substring(0, index2) + normalized.substring(index + 3);
        }
        return normalized;
    }

    protected File file(String name) {
        name = SSOCacheResource.getInstance().decodeName(name);
        File file = new File(this.base, name);
        if (!file.exists() && name.endsWith(".gz")) {
            name = name.substring(0, name.lastIndexOf(".gz"));
            file = new File(this.base, name);
        }
        if (file.exists() && file.canRead()) {
            if (this.allowLinking) {
                return file;
            }
            String canPath = null;
            try {
                canPath = file.getCanonicalPath();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (canPath == null) {
                return null;
            }
            if (!canPath.startsWith(this.absoluteBase)) {
                return null;
            }
            if (this.caseSensitive) {
                String fileAbsPath = file.getAbsolutePath();
                if (fileAbsPath.endsWith(".")) {
                    fileAbsPath = fileAbsPath + "/";
                }
                String absPath = this.normalize(fileAbsPath);
                if (canPath != null) {
                    canPath = this.normalize(canPath);
                }
                if (this.absoluteBase.length() < absPath.length() && this.absoluteBase.length() < canPath.length()) {
                    absPath = absPath.substring(this.absoluteBase.length() + 1);
                    if (canPath == null || absPath == null) {
                        return null;
                    }
                    if (absPath.equals("")) {
                        absPath = "/";
                    }
                    if ((canPath = canPath.substring(this.absoluteBase.length() + 1)).equals("")) {
                        canPath = "/";
                    }
                    if (!canPath.equals(absPath)) {
                        return null;
                    }
                }
            }
        } else {
            return null;
        }
        return file;
    }

    @Override
    public List list(String name) throws NamingException {
        File file = this.file(name);
        if (file == null) {
            throw new NamingException(name + " fine not find.");
        }
        return this.list(file);
    }

    protected ArrayList list(File file) {
        ArrayList<SSONamingEntry> entries = new ArrayList<SSONamingEntry>();
        if (!file.isDirectory()) {
            return entries;
        }
        Object[] names = file.list();
        if (names == null) {
            return entries;
        }
        Arrays.sort(names);
        if (names == null) {
            return entries;
        }
        SSONamingEntry entry = null;
        for (int i = 0; i < names.length; ++i) {
            File currentFile = new File(file, (String)names[i]);
            Object object = null;
            if (currentFile.isDirectory()) {
                SSOFileDirContext tempContext = new SSOFileDirContext();
                tempContext.setDocBase(file.getPath());
                tempContext.setAllowLinking(this.getAllowLinking());
                tempContext.setCaseSensitive(this.isCaseSensitive());
                object = tempContext;
            } else {
                object = new FileResource(currentFile);
            }
            entry = new SSONamingEntry((String)names[i], object, 0);
            entries.add(entry);
        }
        return entries;
    }

    protected class FileResource
    extends SSOResource {
        protected File file;
        protected long length = -1L;

        public FileResource(File file) {
            this.file = file;
        }

        @Override
        public InputStream streamContent() throws IOException {
            if (this.binaryContent == null) {
                this.inputStream = new FileInputStream(this.file);
            }
            return super.streamContent();
        }
    }
}

