/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.bicomponent;

import com.kingdee.bos.ctrl.analysis.bicomponent.CellItem;
import com.kingdee.bos.ctrl.analysis.olap.Member;
import com.kingdee.bos.ctrl.analysis.olap.MemberTree;
import com.kingdee.bos.ctrl.analysis.olap.OlapModel;
import com.kingdee.bos.ctrl.analysis.olap.Position;
import com.kingdee.bos.ctrl.kdf.export.IExportObject;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;

public class MemberCellItem
extends CellItem
implements IExportObject {
    Position position;
    Member member;
    boolean isLeaf;
    boolean isVirtual;

    MemberCellItem(OlapModel model, Position position, Member member, int locate, boolean virtual) {
        this(model, position, member, locate);
        this.isVirtual = virtual;
    }

    MemberCellItem(OlapModel model, Position position, Member member, int locate) {
        super(model, 1, locate);
        this.position = position;
        this.member = member;
        MemberTree mt = (MemberTree)model.getExtension("memberTree");
        this.isLeaf = !mt.hasChildren(member);
    }

    Member getMember() {
        return this.member;
    }

    Position getPosition() {
        return this.position;
    }

    public String toString() {
        if (this.member != null) {
            return this.member.getLabel();
        }
        return "";
    }

    public boolean equals(Object x) {
        if (!(x instanceof MemberCellItem)) {
            return false;
        }
        MemberCellItem mci = (MemberCellItem)x;
        return this.member.equals(mci.member) && this.isVirtual == mci.isVirtual;
    }

    public boolean isLeaf() {
        return this.isLeaf;
    }

    public boolean isVirtual() {
        return this.isVirtual;
    }

    public void setVirtual(boolean isVirtual) {
        this.isVirtual = isVirtual;
    }

    @Override
    public Styles.HorizontalAlignment getHorizontalAlignment() {
        if (this.inColumns()) {
            return Styles.HorizontalAlignment.CENTER;
        }
        return Styles.HorizontalAlignment.LEFT;
    }

    public Object getContent() {
        return this.toString();
    }

    public String getFormatString() {
        return "@";
    }
}

