/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.bicomponent;

import com.kingdee.bos.ctrl.analysis.bicomponent.BIComponentBase;
import com.kingdee.bos.ctrl.analysis.bicomponent.BIComponentResource;
import com.kingdee.bos.ctrl.analysis.bicomponent.CellItem;
import com.kingdee.bos.ctrl.analysis.bicomponent.CellRender;
import com.kingdee.bos.ctrl.analysis.bicomponent.ComponentConfig;
import com.kingdee.bos.ctrl.analysis.bicomponent.HierarchyCellItem;
import com.kingdee.bos.ctrl.analysis.bicomponent.event.CellItemClickEvent;
import com.kingdee.bos.ctrl.analysis.olap.Hierarchy;
import com.kingdee.bos.ctrl.analysis.olap.Member;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import java.awt.Component;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class SlicerListComponent
extends BIComponentBase {
    private KDTable table;
    CellRender render;
    KDTMouseListener mouseListener = new KDTMouseListener(){

        public void tableClicked(KDTMouseEvent e) {
            int row = e.getRowIndex();
            int column = e.getColIndex();
            if (SwingUtilities.isLeftMouseButton((MouseEvent)e)) {
                SlicerListComponent.this.cellClicked(SlicerListComponent.this.table, e.getClickCount() == 2, row, column, e.getOriginView(), e.getX(), e.getY());
            } else {
                SlicerListComponent.this.popup(SlicerListComponent.this.table, row, column, e.getOriginView(), e.getX(), e.getY());
            }
        }
    };

    public SlicerListComponent(KDTable table) {
        this(table, ComponentConfig.getConfig());
    }

    public SlicerListComponent(KDTable table, ComponentConfig config) {
        super(config);
        if (table == null || config == null) {
            throw new NullPointerException();
        }
        this.table = table;
        this.render = new CellRender(null, config);
        table.removeRows();
        table.removeColumns();
        table.removeHeadRows();
        table.addHeadRow();
        table.addColumn();
        table.addColumn();
        table.getIndexColumn().getStyleAttributes().setHided(true);
        table.setAutoResize(true);
        table.getStyleAttributes().setLocked(true);
        table.getHeadRow(0).getCell(0).setValue((Object)BIComponentResource.getString(BIComponentResource.class, (String)"Dimension"));
        table.getHeadRow(0).getCell(1).setValue((Object)BIComponentResource.getString(BIComponentResource.class, (String)"SlicerMember"));
        table.addKDTMouseListener(this.mouseListener);
    }

    void popup(KDTable table, int row, int column, Component parent, int x, int y) {
        try {
            table.getSelectManager().select(row, column);
        }
        catch (Exception exception) {
            // empty catch block
        }
        ICell cell = table.getCell(row, column);
        if (cell == null) {
            return;
        }
        Object value = cell.getValue();
        if (value instanceof HierarchyCellItem) {
            this.popupCellItem = (CellItem)value;
            this.popupForHierarchy((HierarchyCellItem)value, parent, x, y);
        }
        if (value instanceof CellItem) {
            CellItemClickEvent event = new CellItemClickEvent((CellItem)value, false, true);
            this.fireCellItemClicked(event);
        }
    }

    void cellClicked(KDTable table, boolean doubleClick, int row, int column, Component parent, int x, int y) {
        try {
            table.getSelectManager().select(row, column);
        }
        catch (Exception exception) {
            // empty catch block
        }
        ICell cell = table.getCell(row, column);
        if (cell == null) {
            return;
        }
        Object value = cell.getValue();
        if (value instanceof CellItem) {
            CellItemClickEvent event = new CellItemClickEvent((CellItem)value, doubleClick, false);
            this.fireCellItemClicked(event);
        }
    }

    @Override
    public JComponent getJComponent() {
        return this.table;
    }

    @Override
    public void render() {
        if (this.table == null || this.olapModel == null) {
            return;
        }
        this.table.removeRows();
        int sliceRow = 0;
        Member[] sliceMembers = this.getChangeSlicer().getSlicer();
        int size = sliceMembers.length;
        Hierarchy[] sliceHierarchies = new Hierarchy[size];
        if (size > 0) {
            sliceRow = size;
            for (int i = 0; i < sliceRow; ++i) {
                Hierarchy hie;
                IRow row = this.table.addRow(i);
                row.setHeight(24);
                Member member = sliceMembers[i];
                sliceHierarchies[i] = hie = member.getLevel().getHierarchy();
                HierarchyCellItem hci = new HierarchyCellItem(this.olapModel, hie, 2, member);
                this.fillCellItem(this.table, i, 0, hci);
                this.table.getCell(i, 1).setValue((Object)member.getLabel());
            }
        }
        this.table.reLayoutAndPaint();
        this.popupMenuForHierarchy = null;
    }

    private void fillCellItem(KDTable table, int row, int column, CellItem cellInfo) {
        ICell cell = table.getCell(row, column);
        cell.setValue((Object)cellInfo);
        cell.setRenderer((IBasicRender)((CellRender)this.render.clone()));
    }
}

