/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.bicomponent.layout;

import com.kingdee.bos.ctrl.analysis.bicomponent.BIComponentResource;
import com.kingdee.bos.ctrl.analysis.bicomponent.OlapModelUtil;
import com.kingdee.bos.ctrl.analysis.bicomponent.layout.ComponentDragSource;
import com.kingdee.bos.ctrl.analysis.bicomponent.layout.DimComponent;
import com.kingdee.bos.ctrl.analysis.bicomponent.layout.DivSpanPanel;
import com.kingdee.bos.ctrl.analysis.bicomponent.layout.PanelDropTarget;
import com.kingdee.bos.ctrl.analysis.olap.Axis;
import com.kingdee.bos.ctrl.analysis.olap.AxisMembersHelper;
import com.kingdee.bos.ctrl.analysis.olap.Hierarchy;
import com.kingdee.bos.ctrl.analysis.olap.Member;
import com.kingdee.bos.ctrl.analysis.olap.OlapException;
import com.kingdee.bos.ctrl.analysis.olap.OlapModel;
import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.swing.KDButton;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.olap.mdx.Exp;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JPanel;

public class LayoutDesigner
extends KDDialog
implements DragGestureListener {
    private Map dimComponentMap = new HashMap();
    private boolean isOK = false;
    BorderLayout borderLayout1 = new BorderLayout();
    KDPanel KDPanel7 = new KDPanel();
    KDPanel KDPanel1 = new KDPanel();
    KDButton jbOK = new KDButton();
    KDButton jbCancel = new KDButton();
    DivSpanPanel jpSpan = new DivSpanPanel();
    KDPanel jpSlicer = new KDPanel();
    KDPanel jpLeft = new KDPanel();
    KDPanel jpTop = new KDPanel();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    KDPanel KDPanel6 = new KDPanel();
    KDPanel KDPanel8 = new KDPanel();
    KDPanel KDPanel9 = new KDPanel();
    KDButton jbTest = new KDButton();
    private OlapModel olapModel;
    ContainerListener cl = new ContainerListener(){

        @Override
        public void componentAdded(ContainerEvent e) {
            this.fireSpanChanged();
            ((KDPanel)e.getSource()).updateUI();
        }

        @Override
        public void componentRemoved(ContainerEvent e) {
            this.fireSpanChanged();
            ((KDPanel)e.getSource()).updateUI();
        }

        private void fireSpanChanged() {
            int r = LayoutDesigner.this.jpLeft.getComponentCount();
            int c = LayoutDesigner.this.jpTop.getComponentCount();
            String[] rows = new String[r];
            String[] cols = new String[c];
            LayoutDesigner.this.jpSpan.setDiv(rows, cols);
            LayoutDesigner.this.jpSpan.updateUI();
        }
    };

    public LayoutDesigner() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.init();
    }

    public LayoutDesigner(Dialog owner) throws HeadlessException {
        super(owner);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.init();
    }

    public LayoutDesigner(Frame owner) throws HeadlessException {
        super(owner);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.init();
    }

    public void setOlapModel(OlapModel olapModel) {
        this.olapModel = olapModel;
    }

    public boolean showDialog() {
        this.dimComponentMap.clear();
        this.jpLeft.removeAll();
        this.jpTop.removeAll();
        this.jpSlicer.removeAll();
        try {
            Axis row = OlapModelUtil.getLeftAxis(this.olapModel);
            int n = row.getHierarchies().length;
            for (int i = 0; i < n; ++i) {
                this.buildDimComponent(row.getHierarchies()[i], this.jpLeft);
            }
            Axis col = OlapModelUtil.getTopAxis(this.olapModel);
            int n2 = col.getHierarchies().length;
            for (int i = 0; i < n2; ++i) {
                this.buildDimComponent(col.getHierarchies()[i], this.jpTop);
            }
            Member[] sliceMembers = OlapModelUtil.getSliceMembers(this.olapModel);
            for (int i = 0; i < sliceMembers.length; ++i) {
                this.buildDimComponent(sliceMembers[i].getHierarchy(), this.jpSlicer);
            }
            this.setVisible(true);
        }
        catch (Exception e) {
            WindowUtil.alert((Component)((Object)this), (String)e.getMessage());
            return false;
        }
        return this.isOK;
    }

    private void buildDimComponent(Hierarchy h, KDPanel p) {
        DimComponent dc = new DimComponent(h.getLabel());
        new ComponentDragSource((Component)((Object)dc), 2);
        this.dimComponentMap.put(dc, h);
        p.add((Component)((Object)dc), null);
    }

    private void jbInit() throws Exception {
        this.setSize(465, 350);
        this.setTitle(BIComponentResource.getString(BIComponentResource.class, (String)"LayoutDesigner"));
        this.getContentPane().setLayout(this.borderLayout1);
        this.jbOK.setText(BIComponentResource.getString(BIComponentResource.class, (String)"OK"));
        this.jbCancel.setText(BIComponentResource.getString(BIComponentResource.class, (String)"Cancel"));
        this.KDPanel1.setLayout((LayoutManager)this.gridBagLayout1);
        this.jpSpan.setBorder(BorderFactory.createEtchedBorder());
        this.jpTop.setBorder(BorderFactory.createEtchedBorder());
        this.jpTop.setMinimumSize(new Dimension(100, 70));
        this.jpTop.setPreferredSize(new Dimension(100, 70));
        this.jpLeft.setBorder(BorderFactory.createEtchedBorder());
        this.jpLeft.setMinimumSize(new Dimension(100, 14));
        this.jpLeft.setPreferredSize(new Dimension(100, 14));
        this.jpSlicer.setBorder(BorderFactory.createEtchedBorder());
        this.jpSlicer.setMinimumSize(new Dimension(100, 14));
        this.jpSlicer.setPreferredSize(new Dimension(100, 14));
        this.KDPanel1.setBorder(BorderFactory.createEtchedBorder());
        this.jbOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LayoutDesigner.this.jbOK_actionPerformed(e);
            }
        });
        this.jbCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LayoutDesigner.this.jbCancel_actionPerformed(e);
            }
        });
        this.getContentPane().add((Component)this.KDPanel7, "South");
        this.KDPanel7.add((Component)this.jbOK, null);
        this.KDPanel7.add((Component)this.jbCancel, null);
        this.KDPanel7.add((Component)this.jbTest, null);
        this.getContentPane().add((Component)this.KDPanel1, "Center");
        this.KDPanel1.add((Component)this.jpSpan, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.KDPanel1.add((Component)this.jpTop, (Object)new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.KDPanel1.add((Component)this.jpLeft, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 1.0, 10, 1, new Insets(0, 0, 1, 0), 0, 0));
        this.KDPanel1.add((Component)this.jpSlicer, (Object)new GridBagConstraints(1, 1, 1, 1, 10.0, 10.0, 10, 1, new Insets(0, 0, 1, 0), 0, 0));
        this.getContentPane().add((Component)this.KDPanel6, "West");
        this.getContentPane().add((Component)this.KDPanel8, "East");
        this.getContentPane().add((Component)this.KDPanel9, "North");
    }

    private void init() {
        this.setModal(true);
        this.jbTest.setVisible(false);
        this.enableEvents(64L);
        WindowUtil.makeCneterBounds((Window)((Object)this));
        this.jpTop.setLayout((LayoutManager)new FlowLayout(0));
        this.jpSlicer.setLayout((LayoutManager)new FlowLayout(0));
        new PanelDropTarget((JPanel)this.jpSlicer);
        new PanelDropTarget((JPanel)this.jpLeft);
        new PanelDropTarget((JPanel)this.jpTop);
        this.setDefaultCloseOperation(2);
        this.jpLeft.addContainerListener(this.cl);
        this.jpTop.addContainerListener(this.cl);
        this.jpSlicer.addContainerListener(this.cl);
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent dge) {
    }

    void jbOK_actionPerformed(ActionEvent e) {
        if (this.ok()) {
            this.close(true);
        }
    }

    private boolean ok() {
        AxisMembersHelper p = (AxisMembersHelper)this.olapModel.getExtension("axisMembersHelper");
        Hierarchy[] rows = this.getRowHierarchy();
        Hierarchy[] columns = this.getColumnHierarchy();
        if (rows == null || rows.length == 0) {
            WindowUtil.alert((Component)((Object)this), (String)BIComponentResource.getString(BIComponentResource.class, (String)"RowHeaderNotNull"));
            return false;
        }
        if (columns == null || columns.length == 0) {
            WindowUtil.alert((Component)((Object)this), (String)BIComponentResource.getString(BIComponentResource.class, (String)"ColumnHeaderNotNull"));
            return false;
        }
        Axis columnAxis = null;
        try {
            columnAxis = OlapModelUtil.getTopAxis(this.olapModel);
        }
        catch (OlapException e) {
            e.printStackTrace();
        }
        Axis rowAxis = null;
        try {
            rowAxis = OlapModelUtil.getLeftAxis(this.olapModel);
        }
        catch (OlapException e) {
            e.printStackTrace();
        }
        Exp[] rowExps = new Exp[rows.length];
        for (int i = 0; i < rowExps.length; ++i) {
            rowExps[i] = p.createMemberExpression(rows[i]);
        }
        Exp[] columnExps = new Exp[columns.length];
        for (int i = 0; i < columnExps.length; ++i) {
            columnExps[i] = p.createMemberExpression(columns[i]);
        }
        p.setQueryAxis(new Axis[]{rowAxis, columnAxis}, new Hierarchy[][]{rows, columns}, new Exp[][]{rowExps, columnExps});
        return true;
    }

    private Hierarchy[] getRowHierarchy() {
        return this.getHierarchy(this.jpLeft);
    }

    private Hierarchy[] getColumnHierarchy() {
        return this.getHierarchy(this.jpTop);
    }

    private Hierarchy[] getHierarchy(KDPanel parent) {
        ArrayList hList = new ArrayList();
        int n = parent.getComponentCount();
        for (int i = 0; i < n; ++i) {
            Component c = parent.getComponent(i);
            if (!this.dimComponentMap.containsKey(c)) continue;
            hList.add(this.dimComponentMap.get(c));
        }
        Hierarchy[] hs = new Hierarchy[hList.size()];
        hList.toArray(hs);
        return hs;
    }

    void jbCancel_actionPerformed(ActionEvent e) {
        this.close(false);
    }

    private void close(boolean ok) {
        this.isOK = ok;
        this.dispose();
    }

    protected void processWindowEvent(WindowEvent e) {
        if (e.getID() == 201) {
            this.close(false);
        } else {
            super.processWindowEvent(e);
        }
    }
}

