/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.bicomponent.layout;

import com.kingdee.bos.ctrl.analysis.bicomponent.layout.ComponentDragSource;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.util.ArrayList;
import javax.swing.JPanel;

public class PanelDropTarget
implements DropTargetListener {
    private JPanel panel;
    private Point lastP;
    private Color bg;

    public PanelDropTarget(JPanel aPanel) {
        this.panel = aPanel;
        new DropTarget(this.panel, this);
        this.bg = this.panel.getBackground();
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
        this.panel.setBackground(this.brighter(this.bg, 0.9f));
    }

    private Color brighter(Color c, float FACTOR) {
        int r = c.getRed();
        int g = c.getGreen();
        int b = c.getBlue();
        int i = (int)(1.0 / (1.0 - (double)FACTOR));
        if (r == 0 && g == 0 && b == 0) {
            return new Color(i, i, i);
        }
        if (r > 0 && r < i) {
            r = i;
        }
        if (g > 0 && g < i) {
            g = i;
        }
        if (b > 0 && b < i) {
            b = i;
        }
        return new Color(Math.min((int)((float)r / FACTOR), 255), Math.min((int)((float)g / FACTOR), 255), Math.min((int)((float)b / FACTOR), 255));
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
        Point p = dtde.getLocation();
        if (this.lastP != null && (this.lastP.x != p.x || this.lastP.y != p.y)) {
            this.markTarget(this.lastP);
            this.panel.updateUI();
        }
        this.markTarget(p);
        this.lastP = p;
    }

    private void markTarget(Point p) {
        Graphics g = this.panel.getGraphics();
        g.setColor(Color.RED);
        int lenx = 25;
        int leny = 25;
        g.drawLine(p.x - 25, p.y, p.x + 25, p.y);
        g.drawLine(p.x, p.y - 25, p.x, p.y + 25);
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    private int getDropPositionIndex(Point dropPoint) {
        Point p;
        Component[] cs = this.panel.getComponents();
        ArrayList<Point> list = new ArrayList<Point>();
        for (int j = 0; j < cs.length; ++j) {
            p = cs[j].getLocation();
            p.x += cs[j].getWidth();
            p.y += cs[j].getHeight();
            list.add(p);
        }
        int index = -1;
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            p = (Point)list.get(i);
            if (dropPoint.x > p.x || dropPoint.y > p.y) continue;
            index = i;
            break;
        }
        return index;
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        Transferable tr = dtde.getTransferable();
        try {
            DataFlavor[] flavors = tr.getTransferDataFlavors();
            for (int i = 0; i < flavors.length; ++i) {
                if (!tr.isDataFlavorSupported(flavors[i])) continue;
                Component c = (Component)tr.getTransferData(flavors[i]);
                this.panel.add(c, null, this.getDropPositionIndex(dtde.getLocation()));
                this.panel.updateUI();
                new ComponentDragSource(c, dtde.getDropAction());
                dtde.dropComplete(true);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            dtde.rejectDrop();
        }
        this.panel.setBackground(this.bg);
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
        this.panel.setBackground(this.bg);
    }
}

