/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.common.dbcenter.service;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.analysis.common.dbcenter.DBCenterException;
import com.kingdee.bos.ctrl.analysis.common.dbcenter.EnumObj;
import com.kingdee.bos.ctrl.analysis.common.dbcenter.center.DBCenterModel;
import com.kingdee.bos.ctrl.analysis.common.dbcenter.center.DBCenterModelUtil;
import com.kingdee.bos.ctrl.analysis.common.dbcenter.service.DBCenterUtil;
import com.kingdee.bos.ctrl.analysis.common.dbcenter.service.DBPoolManager;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.framework.ejb.EJBFactory;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class DBCenterManager {
    private static final Logger log = LogUtil.getPackageLogger(DBCenterManager.class);
    private static final Map dbCenterMappings = new Hashtable();

    public static final DBCenterModel getDBCenterModel(Context ctx, String dbCenterId) throws DBCenterException {
        return DBCenterModelUtil.loadModel(DBCenterManager.getSysConnectin(ctx), dbCenterId);
    }

    public static final String getDBCenterBizType(Context ctx, String dbCenterId) throws DBCenterException {
        return DBCenterManager.getDBCenterModel(ctx, dbCenterId).getBusiType();
    }

    public static final List getDBCenterList(Context ctx) throws DBCenterException {
        return DBCenterModelUtil.loadAllEnabledDBCenter(DBCenterManager.getSysConnectin(ctx));
    }

    public static final List getDBCenterList(Connection con) throws DBCenterException {
        return DBCenterModelUtil.loadAllEnabledDBCenter(con);
    }

    public static final EnumObj[] getDBCenters(Context ctx) throws DBCenterException {
        List list = DBCenterModelUtil.loadAllEnabledDBCenter2(DBCenterManager.getSysConnectin(ctx));
        return list.toArray(new EnumObj[list.size()]);
    }

    public static final Connection getConnection(Context ctx, String dbCenterId) throws DBCenterException {
        if (!StringUtil.isEmptyString((String)dbCenterId)) {
            return DBCenterManager.getDBCConnection(ctx, dbCenterId);
        }
        return DBCenterManager.getSysConnectin(ctx);
    }

    public static final Connection getConnection(DBCenterModel model) throws DBCenterException {
        return DBPoolManager.getConnection(model);
    }

    private static final Connection getDBCConnection(Context ctx, String dbCenterId) throws DBCenterException {
        Connection con = null;
        try {
            con = DBCenterManager.getSysConnectin(ctx);
            Connection connection = DBPoolManager.getConnection(con, dbCenterId);
            return connection;
        }
        catch (DBCenterException e) {
            log.error((Object)("\u83b7\u53d6\u6570\u636e\u4e2d\u5fc3\u8fde\u63a5\u5931\u8d25\uff1a" + e));
            throw e;
        }
        finally {
            DBCenterUtil.closeConnection(con);
        }
    }

    private static final Connection getSysConnectin(Context ctx) throws DBCenterException {
        try {
            return EJBFactory.getConnection((Context)ctx);
        }
        catch (SQLException e) {
            log.error((Object)("\u83b7\u53d6\u7cfb\u7edf\u8fde\u63a5\u5931\u8d25\uff1a" + e));
            throw new DBCenterException(e);
        }
    }

    public static String[] getDBCenterNames(Context ctx) throws DBCenterException {
        EnumObj[] dbCenters = DBCenterManager.getDBCenters(ctx);
        String[] dbCenterNames = new String[dbCenters.length];
        String key = ctx.getAIS();
        Hashtable<String, String> mapping = (Hashtable<String, String>)dbCenterMappings.get(key);
        if (mapping == null) {
            mapping = new Hashtable<String, String>();
            dbCenterMappings.put(key, mapping);
        } else {
            mapping.clear();
        }
        int n = dbCenters.length;
        for (int i = 0; i < n; ++i) {
            dbCenterNames[i] = dbCenters[i].getName();
            mapping.put(dbCenters[i].getName(), dbCenters[i].getNumber());
        }
        return dbCenterNames;
    }

    public static Connection getConnectionByName(Context ctx, String dbCenterName) throws DBCenterException {
        String dbCenterId = DBCenterManager.getDBCenterId(ctx, dbCenterName);
        if (StringUtil.isEmptyString((String)dbCenterId)) {
            throw new DBCenterException("\u6570\u636e\u4e2d\u5fc3\u3010" + dbCenterName + "\u3011\u4e0d\u5b58\u5728\u6216\u5df2\u7ecf\u88ab\u5220\u9664\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u4e2d\u5fc3\u5b9a\u4e49\uff01");
        }
        return DBCenterManager.getConnection(ctx, dbCenterId);
    }

    public static String getDBCenterId(Context ctx, String dbCenterName) throws DBCenterException {
        String key = ctx.getAIS();
        if (!dbCenterMappings.containsKey(key)) {
            DBCenterManager.getDBCenterNames(ctx);
        }
        return (String)((Map)dbCenterMappings.get(key)).get(dbCenterName);
    }
}

