/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.mdxw;

import com.kingdee.bos.ctrl.common.LanguageManager;
import com.kingdee.bos.ctrl.common.util.FileUtil;
import com.kingdee.bos.ctrl.kdf.export.POIXlsExporter;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.io.FilenameUtils;

public class FileChooserUtil {
    private JFileChooser jfc = null;
    private Component parent = null;

    public FileChooserUtil(Component parent) {
        this.parent = parent;
        this.jfc = new JFileChooser();
        this.jfc.setMultiSelectionEnabled(false);
    }

    public void setSelectedFile(String path) {
        this.jfc.setSelectedFile(new File(FilenameUtils.normalize((String)path)));
    }

    public File openFile(String title, String exts, String desc) {
        FileFilter[] ff = this.jfc.getChoosableFileFilters();
        for (int i = 0; i < ff.length; ++i) {
            this.jfc.removeChoosableFileFilter(ff[i]);
        }
        this.jfc.addChoosableFileFilter(new MyFileFilter(exts, desc));
        this.jfc.setDialogTitle(title);
        if (this.jfc.showOpenDialog(this.parent) == 0) {
            return this.jfc.getSelectedFile();
        }
        return null;
    }

    public File saveFile(String title, String exts, String desc) {
        FileFilter[] ff = this.jfc.getChoosableFileFilters();
        for (int i = 0; i < ff.length; ++i) {
            this.jfc.removeChoosableFileFilter(ff[i]);
        }
        this.jfc.setFileFilter(new MyFileFilter(exts, desc));
        this.jfc.setDialogTitle(title);
        if (this.jfc.showSaveDialog(this.parent) == 0) {
            File file = this.jfc.getSelectedFile();
            if (!file.getAbsolutePath().endsWith(exts)) {
                file = new File(file.getAbsolutePath() + '.' + exts);
            }
            if (file.exists()) {
                int select = MsgBox.showConfirm2((String)LanguageManager.getLangMessage((String)"56_ExportExcelConfigUI", POIXlsExporter.class, (String)"true"));
                if (select == 2) {
                    return null;
                }
                if (select == 0 && FileUtil.isFileLocked((File)file)) {
                    MsgBox.showError((String)LanguageManager.getLangMessage((String)"57_ExportExcelConfigUI", POIXlsExporter.class, (String)"true"));
                    return null;
                }
            }
            return file;
        }
        return null;
    }

    public static String getExtension(File f) {
        String ext = null;
        String s = f.getName();
        int i = s.lastIndexOf(46);
        if (i > 0 && i < s.length() - 1) {
            ext = s.substring(i + 1).toLowerCase();
        }
        return ext;
    }

    public static File changeExtension(File f, String ext) {
        String s = f.getAbsolutePath();
        int i = s.lastIndexOf(46);
        if (i != -1) {
            s = s.substring(0, i);
        }
        s = s + '.' + ext;
        return new File(s);
    }

    class MyFileFilter
    extends FileFilter {
        private Set extSet = new HashSet();
        private String desc;

        MyFileFilter(String exts, String desc) {
            if (exts != null) {
                String[] s = exts.split(",");
                for (int i = 0; i < s.length; ++i) {
                    String buf = s[i].trim().toLowerCase();
                    if (buf.length() <= 0) continue;
                    this.extSet.add(buf);
                }
            }
            this.desc = desc;
        }

        @Override
        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            String ext = FileChooserUtil.getExtension(f);
            if (ext != null) {
                return this.extSet.contains(ext);
            }
            return false;
        }

        @Override
        public String getDescription() {
            return this.desc;
        }
    }
}

