/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.web.ajax;

import com.kingdee.bos.ctrl.analysis.web.ajax.PageManager;
import com.kingdee.bos.ctrl.analysis.web.ajax.ServletHelper;
import com.kingdee.bos.ctrl.analysis.web.ext.Browser;
import com.kingdee.bos.ctrl.analysis.web.ext.IWebReportService;
import com.kingdee.bos.ctrl.analysis.web.solution.BISystem;
import com.kingdee.bos.ctrl.analysis.web.solution.exception.BIReportException;
import com.kingdee.bos.ctrl.common.util.CommonLogger;
import com.kingdee.bos.json.JSONObject;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLDecoder;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;

public class ExtWebReportHandler {
    public static final String IS_BI_REQUEST = "com.kingdee.bos.ctrl.analysis.web.ajax.ExtWebReportHandler.IS_BI_REQUEST";
    private static IWebReportService webReportService;
    private static final Logger logger;
    private static final String CLASS_NAME = "com.kingdee.eas.rpts.tobi.WebReportService";

    public static void handle(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String ret = "";
        String typeJson = request.getParameter("webJson");
        String urlEncoded = request.getParameter("UrlEncoded");
        String dataStr = ExtWebReportHandler.getDataStr(request);
        if ("true".equals(urlEncoded)) {
            dataStr = URLDecoder.decode(dataStr);
        }
        Browser.setCurrentRequest(request);
        JSONObject dataJson = new JSONObject(dataStr);
        BISystem.getContext(request).put((Object)IS_BI_REQUEST, (Object)true);
        if ("loadReport".equals(typeJson)) {
            ret = webReportService.loadReport(dataJson, request);
        } else if ("applyFilter".equals(typeJson)) {
            ret = webReportService.applyFilter(dataJson, request);
        } else if ("cacheAnalysisReportParam".equals(typeJson)) {
            webReportService.cacheAnalysisReportParam(dataJson, request);
        } else if ("applyRefresh".equals(typeJson)) {
            ret = webReportService.applyRefresh();
        } else if ("getFilter".equals(typeJson)) {
            ret = webReportService.getReportParams(dataJson, request);
        } else if ("getFilterSchemes".equals(typeJson)) {
            ret = webReportService.getFilterSchemes(dataJson, request);
        } else if ("delFilterScheme".equals(typeJson)) {
            ret = webReportService.delFilterScheme(dataJson, request);
        } else if ("saveFilterScheme".equals(typeJson)) {
            ret = webReportService.saveFilterScheme(dataJson, request);
        } else if ("getDelaySuppliedValue".equals(typeJson)) {
            ret = webReportService.getDelaySuppliedValue(dataJson, request);
        } else if ("switchSheet".equals(typeJson)) {
            ret = webReportService.switchSheet(dataJson, request);
        } else if ("cacheParamValues".equals(typeJson)) {
            ret = webReportService.cacheParam(dataJson);
        } else if ("loadFragment".equals(typeJson)) {
            ret = webReportService.lazyLoadFragment(dataJson, request);
        } else if ("lazyLoadTree".equals(typeJson)) {
            ret = webReportService.lazyLoadTree(dataJson, request);
        } else if ("closeReport".equals(typeJson)) {
            webReportService.closeReport(dataJson, request);
        } else if ("chartInnerLink".equals(typeJson)) {
            ret = webReportService.chartInnerLink(dataJson, request);
        } else if ("cellInnerLink".equals(typeJson)) {
            ret = webReportService.cellInnerLink(dataJson, request);
        } else if ("getSecretKey".equals(typeJson)) {
            ret = webReportService.getSecretKey();
        }
        try {
            ServletHelper.writeOut(response, ret);
            if (dataJson.has("pageId")) {
                String pageId = dataJson.getString("pageId");
                PageManager.ping(pageId);
            }
        }
        catch (Exception e) {
            throw new BIReportException(e);
        }
    }

    private static String getDataStr(HttpServletRequest request) throws IOException {
        ServletInputStream is = request.getInputStream();
        byte[] temp = new byte[1024];
        byte[] result = null;
        int length = 0;
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        while ((length = is.read(temp)) > 0) {
            os.write(temp, 0, length);
        }
        result = os.toByteArray();
        IOUtils.closeQuietly((OutputStream)os);
        String dataStr = new String(result, "utf-8");
        return dataStr;
    }

    static {
        logger = CommonLogger.getLogger(ExtWebReportHandler.class);
        if (webReportService == null) {
            try {
                Class<?> classService = Class.forName(CLASS_NAME);
                webReportService = (IWebReportService)classService.newInstance();
            }
            catch (Exception e) {
                logger.warn((Object)"\u672a\u627e\u5230\u6269\u5c55\u62a5\u8868\u7684\u6267\u884c\u5f15\u64ce:[com.kingdee.eas.rpts.tobi.WebReportService]", (Throwable)e);
            }
        }
    }
}

