/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.web.ajax;

import com.kingdee.bos.ctrl.analysis.web.ajax.Constants;
import com.kingdee.bos.ctrl.analysis.web.ajax.FilterUIO;
import com.kingdee.bos.ctrl.analysis.web.ajax.UIO;
import com.kingdee.bos.ctrl.analysis.web.ajax.UIOManager;
import com.kingdee.bos.ctrl.analysis.web.ajax.WebPage;
import com.kingdee.bos.ctrl.analysis.web.ajax.json.JSONMap;
import com.kingdee.bos.ctrl.analysis.web.session.ThemeAnalysisReportState;
import com.kingdee.bos.ctrl.analysis.web.session.UserSessionHelper;
import com.kingdee.bos.ctrl.analysis.web.solution.BIReport;
import com.kingdee.bos.ctrl.analysis.web.solution.Report;
import com.kingdee.bos.ctrl.analysis.web.solution.exception.BIReportException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public abstract class ReportPage
extends WebPage {
    public static final String uiSeperatorComponent = "||";
    public static final String uiSeperatorScheme = "~~";
    public static final String filterSchemeName = "filter";
    protected UIOManager uioManager;
    protected String type;
    protected Report report;
    private Object[] nowFilterParams = null;
    private Object[] nowFilterCaptionParams = null;

    public abstract boolean canUseRepository();

    protected abstract String generateUI(HttpServletRequest var1) throws BIReportException;

    public ReportPage(String pageId, String type, Report report) {
        super(pageId);
        this.type = type;
        this.report = report;
        this.uioManager = new UIOManager(this);
    }

    public Report getReport() {
        return this.report;
    }

    public synchronized void setFilterParams(Object[] params) {
        this.nowFilterParams = params;
    }

    public Object[] getFilterParams() {
        return this.nowFilterParams;
    }

    public synchronized void setFilterCaptionParams(Object[] params) {
        this.nowFilterCaptionParams = params;
    }

    public Object[] getFilterCaptionParams() {
        return this.nowFilterCaptionParams;
    }

    public String init(HttpServletRequest request) throws BIReportException {
        String caption = request.getParameter("caption");
        if (caption != null) {
            HttpSession session = UserSessionHelper.getUserSession(request);
            Set set = (Set)session.getAttribute("lastReportSet");
            String queryString = request.getQueryString();
            String from = request.getParameter("from");
            String url = request.getRequestURI() + "?" + queryString.substring(0, queryString.indexOf("&caption"));
            ThemeAnalysisReportState o = new ThemeAnalysisReportState(caption, url, from);
            Iterator it = set.iterator();
            ThemeAnalysisReportState temp = null;
            while (it.hasNext()) {
                temp = (ThemeAnalysisReportState)it.next();
                if (!temp.getFrom().equals(from)) continue;
                if (temp.getUrl().equals(url)) {
                    temp.setSelected(true);
                    o = null;
                    continue;
                }
                temp.setSelected(false);
            }
            if (o != null) {
                set.add(o);
            }
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("content", this.generateUI(request));
        map.put("reportType", this.getType());
        map.put("useRepository", new Boolean(this.canUseRepository()));
        map.put("pageId", this.pageId + "");
        map.put("url", request.getContextPath() + "/" + Constants.SERVLET_URL);
        map.put("urlSeparator", "\u0001");
        if (this.getReport() instanceof BIReport) {
            map.put("isDefaultOpenDataDrill", ((BIReport)this.getReport()).isDefaultOpenDataDrill());
        }
        return new JSONMap(map).toString();
    }

    public static void createUIOInfo(UIO uio, StringBuffer sb) {
        sb.append("ui:" + uio.getId() + "," + uio.getName() + "," + uio.getCaption() + "," + uio.getType());
    }

    @Override
    public void close() {
        this.uioManager.release();
    }

    public String getType() {
        return this.type;
    }

    public UIO getUIO(String uiid) {
        return this.uioManager.getUIO(uiid);
    }

    public FilterUIO getFilterUIO() {
        UIO[] uios = this.uioManager.getAllUIOs();
        for (int ii = 0; ii < uios.length; ++ii) {
            if (!(uios[ii] instanceof FilterUIO)) continue;
            return (FilterUIO)uios[ii];
        }
        return null;
    }
}

