/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.web.ajax;

import com.kingdee.bos.ctrl.analysis.olap.Cell;
import com.kingdee.bos.ctrl.analysis.olap.Level;
import com.kingdee.bos.ctrl.analysis.olap.Member;
import com.kingdee.bos.ctrl.analysis.olap.OlapException;
import com.kingdee.bos.ctrl.analysis.olap.OlapModel;
import com.kingdee.bos.ctrl.analysis.olapadapter.kingdeeolap.KDOLAP_Cell;
import com.kingdee.bos.ctrl.analysis.web.BIWebComponent;
import com.kingdee.bos.ctrl.analysis.web.ajax.BIReportPage;
import com.kingdee.bos.ctrl.analysis.web.ajax.Constants;
import com.kingdee.bos.ctrl.analysis.web.ajax.MdxQueryO;
import com.kingdee.bos.ctrl.analysis.web.ajax.UIO;
import com.kingdee.bos.ctrl.analysis.web.ajax.json.JSONString;
import com.kingdee.bos.ctrl.analysis.web.link.DimensionLink;
import com.kingdee.bos.ctrl.analysis.web.piece.DynamicPiece;
import com.kingdee.bos.ctrl.analysis.web.piece.Piece;
import com.kingdee.bos.ctrl.analysis.web.piece.SnapshotPiece;
import com.kingdee.bos.ctrl.analysis.web.solution.BIReport;
import com.kingdee.bos.ctrl.analysis.web.solution.BIReportComponent;
import com.kingdee.bos.ctrl.analysis.web.solution.exception.BIReportException;
import com.kingdee.bos.ctrl.analysis.web.solution.impl.BIReportChartComponent;
import com.kingdee.bos.ctrl.analysis.web.solution.util.IDGenerator;
import com.kingdee.bos.ctrl.analysis.web.worklist.WorklistComponent;
import com.kingdee.bos.ctrl.analysis.web.worksheet.WorksheetComponent;
import com.kingdee.bos.ctrl.analysis.web.worksheet.span.Span;
import com.kingdee.bos.ctrl.common.util.CommonLogger;
import com.kingdee.bos.olap.OLAPException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class WorksheetUIO
extends UIO {
    private static final Logger log = CommonLogger.getLogger(WorksheetUIO.class);
    private BIReportComponent wrc;
    private WorksheetComponent component = null;
    private MdxQueryO mdxQueryO = null;
    private BIReportPage page;
    private int worksheetWidth = 0;
    private int worksheetHeight = 0;
    private int defaultWorksheetWidth = 700;
    private int defaultWorksheetHeight = 400;

    WorksheetUIO(BIReportPage page, BIReportComponent wrc, String schemename, int perPageRows) throws BIReportException {
        super(page, wrc.getName(), wrc.getCaption(), "worksheet", schemename, perPageRows);
        this.page = page;
        this.init(wrc);
    }

    private void init(BIReportComponent wrc) throws BIReportException {
        this.wrc = wrc;
        this.mdxQueryO = this.page.getMdxQueryOManager().getMdxQueryO(wrc.getMdxQuery());
        if (this.mdxQueryO == null) {
            this.mdxQueryO = this.page.getMdxQueryOManager().createMdxQueryO(wrc.getMdxQuery(), wrc.getMdx());
        }
    }

    public BIReportComponent getBIReportComponent() {
        return this.wrc;
    }

    public void updateMdxQueryO(MdxQueryO mdxQueryO) {
        this.mdxQueryO = mdxQueryO;
    }

    @Override
    public BIWebComponent getComponent() {
        return this.component;
    }

    public MdxQueryO getMdxQueryO() {
        return this.mdxQueryO;
    }

    private void initComponent(HttpServletRequest request) throws BIReportException {
        OlapModel olapModel = this.mdxQueryO.getOlapModel(request);
        this.component = new WorksheetComponent(this.getId().toString(), this.getCaption(), olapModel, this.page.getDimLinkManager(), this.getSchemeName());
        String s = this.wrc.getProperty("showColumnHeader");
        this.component.setShowColumnHeader(s == null || "true".equals(s));
        try {
            this.component.initialize();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BIReportException(e);
        }
    }

    private boolean isSingleWorksheetPage() {
        BIReport bireport = (BIReport)this.page.getReport();
        List list = bireport.getComponents(this.getSchemeName());
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            if (!(iter.next() instanceof BIReportChartComponent)) continue;
            return false;
        }
        return true;
    }

    private int getWorksheetWidth(String pageWidth) {
        if (pageWidth == null || pageWidth.equals("") || pageWidth.equals("null")) {
            return this.worksheetWidth;
        }
        this.worksheetWidth = Integer.parseInt(pageWidth) - 50;
        return this.worksheetWidth;
    }

    private int getWorksheetHeight(String pageHeight) {
        if (pageHeight == null || pageHeight.equals("") || pageHeight.equals("null")) {
            return this.worksheetHeight;
        }
        if (!this.isSingleWorksheetPage()) {
            return 0;
        }
        this.worksheetHeight = Integer.parseInt(pageHeight) - 180;
        return this.worksheetHeight;
    }

    private int getRowCountHeight(int fontHeight) {
        int rowCount = this.component.getRowCountIncludeHeader();
        if (rowCount < 5) {
            return rowCount * fontHeight + 15;
        }
        return rowCount * fontHeight + 5;
    }

    @Override
    protected Map getParametersForXSL(HttpServletRequest request) {
        Map parameters = super.getParametersForXSL(request);
        String fontSizeKey = this.wrc.getProperty("fontSize");
        String fontSize = FontSize.getValue(fontSizeKey);
        parameters.put("fontSize", fontSize);
        int fontHeight = FontSize.getHeight(fontSizeKey);
        int worksheetWidth = this.getWorksheetWidth("" + request.getParameter("pageWidth"));
        if (worksheetWidth > 0) {
            parameters.put("worksheet_width", "" + worksheetWidth);
        } else {
            parameters.put("worksheet_width", "" + this.defaultWorksheetWidth);
        }
        int worksheetHeight = this.getWorksheetHeight("" + request.getParameter("pageHeight"));
        int rowCountHeight = this.getRowCountHeight(fontHeight);
        if (worksheetHeight > 0) {
            if (worksheetHeight > rowCountHeight) {
                worksheetHeight = rowCountHeight;
            }
            parameters.put("worksheet_height", "" + worksheetHeight);
        } else if (this.defaultWorksheetHeight > rowCountHeight) {
            parameters.put("worksheet_height", "" + rowCountHeight);
        } else {
            parameters.put("worksheet_height", "" + this.defaultWorksheetHeight);
        }
        String[] keys = new String[]{"canMoveDimension", "showRowDimensionInSlicer", "showColumnDimensionInSlicer"};
        for (int i = 0; i < keys.length; ++i) {
            String s = this.wrc.getProperty(keys[i]);
            s = "true".equals(s) || s == null ? "true" : "false";
            parameters.put(keys[i], s);
        }
        return parameters;
    }

    @Override
    public String service(HttpServletRequest request) throws BIReportException {
        if (this.component == null) {
            this.initComponent(request);
        } else if (this.component.setOlapModel(this.mdxQueryO.getOlapModel(request))) {
            try {
                this.component.initialize();
            }
            catch (Exception e) {
                throw new BIReportException(e);
            }
        }
        String requestType = request.getParameter("type");
        if ("init".equalsIgnoreCase(requestType)) {
            boolean showSlicer;
            StringBuffer sb = new StringBuffer();
            this.component.setPagePerRows(this.perPageRows);
            String attSlicer = this.wrc.getProperty("showSlicer");
            boolean bl = showSlicer = attSlicer == null || !"false".equalsIgnoreCase(attSlicer);
            if (showSlicer) {
                sb.append(this.transXSL(request, Constants.PATH_XSL_SLICER, this.component));
            }
            sb.append(this.transXSL(request, Constants.PATH_XSL_WORKSHEET, this.component));
            return sb.toString();
        }
        if ("refresh".equalsIgnoreCase(requestType)) {
            StringBuffer sb = new StringBuffer();
            String withSlicer = request.getParameter("withSlicer");
            if ("true".equalsIgnoreCase(withSlicer)) {
                boolean showSlicer;
                String attSlicer = this.wrc.getProperty("showSlicer");
                boolean bl = showSlicer = attSlicer == null || !"false".equalsIgnoreCase(attSlicer);
                if (showSlicer) {
                    sb.append(this.transXSL(request, Constants.PATH_XSL_SLICER, this.component));
                }
            }
            sb.append(this.transXSL(request, Constants.PATH_XSL_WORKSHEET, this.component));
            return sb.toString();
        }
        if ("action".equalsIgnoreCase(requestType)) {
            String actionName = request.getParameter("actionName");
            if ("doExpandCollapse".equalsIgnoreCase(actionName)) {
                return this.doExpandCollapse(request, this.mdxQueryO);
            }
            if ("doDataDrill".equalsIgnoreCase(actionName)) {
                return this.doDataDrill(request, this.mdxQueryO);
            }
            if ("doLink".equalsIgnoreCase(actionName)) {
                return this.doLink(request, this.mdxQueryO);
            }
            if ("setListPage".equalsIgnoreCase(actionName)) {
                return this.doChangeListPage(request, this.mdxQueryO);
            }
            if ("setListPerPageRows".equalsIgnoreCase(actionName)) {
                return this.doChangeListPerPageRows(request, this.mdxQueryO);
            }
            if ("exportList".equalsIgnoreCase(actionName)) {
                return this.doExportList(request, this.mdxQueryO);
            }
            if ("sortList".equalsIgnoreCase(actionName)) {
                return this.doSortList(request, this.mdxQueryO);
            }
            if ("sortList2".equalsIgnoreCase(actionName)) {
                return this.doSortList2(request, this.mdxQueryO);
            }
            if ("getColumnValues".equalsIgnoreCase(actionName)) {
                return this.getColumnValues(request);
            }
            if ("filterList".equalsIgnoreCase(actionName)) {
                return this.doFilterList(request);
            }
            if ("closeList".equalsIgnoreCase(actionName)) {
                return this.doCloseList(request, this.mdxQueryO);
            }
            if ("getSlicerChildren".equalsIgnoreCase(actionName)) {
                return super.getSlicerChildren(request, this.component.getOlapModel());
            }
            if ("getSlicerDescendant".equalsIgnoreCase(actionName)) {
                return this.getSlicerDescendant(request, this.component.getOlapModel());
            }
            if ("changeSlicer".equalsIgnoreCase(actionName)) {
                return this.changeSlicer(request, this.mdxQueryO);
            }
            if ("getAllHierarchy".equalsIgnoreCase(actionName)) {
                return this.getAllHierarchy(request, this.component.getOlapModel());
            }
            if ("changeHierarchyMembers".equalsIgnoreCase(actionName)) {
                return this.changeHierarchyMembers(request, this.mdxQueryO);
            }
            if ("swapHierarchy".equalsIgnoreCase(actionName)) {
                return this.swapHierarchy(request, this.mdxQueryO);
            }
            if ("moveAfter".equalsIgnoreCase(actionName)) {
                return this.moveAfter(request, this.mdxQueryO);
            }
            if ("moveBefore".equalsIgnoreCase(actionName)) {
                return this.moveBefore(request, this.mdxQueryO);
            }
            if ("moveTo".equalsIgnoreCase(actionName)) {
                return this.moveTo(request, this.mdxQueryO);
            }
            if ("swapAxis".equalsIgnoreCase(actionName)) {
                return this.swapAxis(request, this.mdxQueryO);
            }
            if ("getVisibleMember".equalsIgnoreCase(actionName)) {
                return this.findVisibleMembers(request, this.mdxQueryO);
            }
            if ("setPerPageRows".equalsIgnoreCase(actionName)) {
                return this.setPerPageRows(request, this.mdxQueryO);
            }
            if ("setPage".equalsIgnoreCase(actionName)) {
                return this.setPage(request, this.mdxQueryO);
            }
            if ("getPage".equalsIgnoreCase(actionName)) {
                return this.component.getPageInfo();
            }
            if ("getSpanInfo".equalsIgnoreCase(actionName)) {
                return this.component.getSpanInfo(request.getParameter("spanId"));
            }
            if ("doMemberDrill".equalsIgnoreCase(actionName)) {
                this.component.doMemberDrill(request.getParameter("spanId"));
                return "";
            }
            if ("doLevelDrill".equalsIgnoreCase(actionName)) {
                this.component.doLevelDrill(request.getParameter("spanId"));
                return "";
            }
            if ("doDrillUp".equalsIgnoreCase(actionName)) {
                this.component.doDrillUp(request.getParameter("spanId"));
                return "";
            }
            if ("doSort".equalsIgnoreCase(actionName)) {
                this.component.doSort(request);
                return super.getUsedUIOString(this.mdxQueryO);
            }
            if ("getSortInfo".equalsIgnoreCase(actionName)) {
                return this.component.getSortInfo(request);
            }
            if ("savePiece".equalsIgnoreCase(actionName)) {
                String strDynamic = request.getParameter("isDynamic");
                boolean isDynamic = "true".equalsIgnoreCase(strDynamic);
                String pieceCaption = request.getParameter("pieceCaption");
                String pieceParentPath = request.getParameter("pieceParentPath");
                String pieceName = "PIECE" + IDGenerator.getUUID();
                Piece piece = null;
                if (isDynamic) {
                    OlapModel model = this.component.getOlapModel();
                    String mdx = model.getCurrentMdx();
                    Object[] params = this.page.getFilterParams();
                    Object[] filterCaptions = this.page.getFilterCaptionParams();
                    BIReport report = this.page.getBIReport();
                    piece = new DynamicPiece(pieceName, pieceCaption, pieceParentPath, mdx, params, filterCaptions, report.getSubjectPath(), report.getPath(), "worksheet", "", this.schemename, report.getRepositoryPath(), null, this.component.getCurrentPage(), this.component.getPerPageRows());
                } else {
                    StringBuffer sb = new StringBuffer();
                    sb.append(this.transXSL(request, Constants.PATH_XSL_PIECE_WORKSHEET, this.component));
                    piece = new SnapshotPiece(pieceName, pieceCaption, pieceParentPath, sb.toString(), "worksheet", this.page.getReport().getRepositoryPath());
                }
                String id = piece.save(request);
                StringBuffer sb = new StringBuffer();
                sb.append("true");
                sb.append(pieceCaption);
                sb.append(",");
                sb.append(id);
                sb.append(",");
                sb.append(pieceParentPath + "/" + pieceName);
                sb.append(",");
                sb.append("false");
                return sb.toString();
            }
            throw new BIReportException("\u975e\u6cd5\u53c2\u6570actionName\u503c\uff1a" + actionName);
        }
        if (requestType == null) {
            throw new BIReportException("\u8bf7\u6c42\u53c2\u6570\u4e2d\u5fc5\u987b\u6709requestType.");
        }
        throw new BIReportException("\u975e\u6cd5\u53c2\u6570requestType\u503c\uff1a" + requestType);
    }

    private String doExpandCollapse(HttpServletRequest request, MdxQueryO mdxQueryO2) {
        String spanId = request.getParameter("spanId");
        this.component.doExpandCollapse(spanId);
        return super.getUsedUIOString(this.mdxQueryO);
    }

    private String doDataDrill(HttpServletRequest request, MdxQueryO mdxQuery) throws BIReportException {
        String sql;
        int row = Integer.parseInt(request.getParameter("row"));
        int column = Integer.parseInt(request.getParameter("column"));
        String reportCaption = request.getParameter("reportCaption");
        Cell cell = null;
        try {
            cell = this.component.getOlapModel().getResult().getCell(column, row);
            sql = this.component.getOlapModel().getKDResult().getQuery().getDataDrillSql(((KDOLAP_Cell)cell).getKDCell());
        }
        catch (OlapException e) {
            throw new BIReportException(e);
        }
        catch (OLAPException e) {
            throw new BIReportException(e);
        }
        if (sql == null) {
            return "";
        }
        String caption = reportCaption == null || "null".equalsIgnoreCase(reportCaption) ? "\u660e\u7ec6\u6570\u636e" : reportCaption + "(\u660e\u7ec6\u6570\u636e)";
        StringBuffer head = new StringBuffer();
        Member[] members = cell.getMemberContext();
        boolean first = true;
        for (int i = 0; i < members.length; ++i) {
            if (members[i].isMeasure()) continue;
            if (first) {
                first = false;
            } else {
                head.append("\t");
            }
            head.append(members[i].getDimension().getCaption() + "\uff1a" + members[i].getCaption());
        }
        WorklistComponent lc = this.page.getWorklistComponentManager().createDataDrillListComponent("DrillData", caption, head.toString(), "", 20, sql);
        return lc.render(request, this.page);
    }

    private String doLink(HttpServletRequest request, MdxQueryO mdxQueryO2) throws BIReportException {
        String spanId = request.getParameter("spanId");
        Span span = this.component.getExpandSpan(spanId);
        String dimension = span.getMember().getDimension().getName();
        Level level = span.getMember().getLevel();
        DimensionLink dl = this.page.getDimLinkManager().findDimensionLink(dimension, this.getSchemeName(), level);
        if (dl == null) {
            throw new BIReportException("\u672a\u627e\u5230\u5bf9\u5e94\u7684\u7a7f\u900f\u5b9a\u4e49!\u7ef4\u5ea6\u540d\uff1a" + dimension + "\u7ea7\u522b\uff1a" + level);
        }
        WorklistComponent lc = this.page.getWorklistComponentManager().createListComponent(dl.getListName());
        return lc.render(request, span, dl, this.page);
    }

    private String doChangeListPage(HttpServletRequest request, MdxQueryO mdxQueryO2) throws BIReportException {
        String listID = request.getParameter("listId");
        WorklistComponent lc = this.page.getWorklistComponentManager().findListComponent(listID);
        return lc.changePage(request, this.page);
    }

    private String doChangeListPerPageRows(HttpServletRequest request, MdxQueryO mdxQueryO2) throws BIReportException {
        String listID = request.getParameter("listId");
        WorklistComponent lc = this.page.getWorklistComponentManager().findListComponent(listID);
        return lc.changePerPageRows(request, this.page);
    }

    private String doExportList(HttpServletRequest request, MdxQueryO mdxQueryO2) throws BIReportException {
        String listID = request.getParameter("listId");
        WorklistComponent lc = this.page.getWorklistComponentManager().findListComponent(listID);
        return lc.export(request, this.page);
    }

    private String doSortList(HttpServletRequest request, MdxQueryO mdxQueryO2) throws BIReportException {
        String listID = request.getParameter("listId");
        WorklistComponent lc = this.page.getWorklistComponentManager().findListComponent(listID);
        return lc.sort(request, this.page);
    }

    private String doSortList2(HttpServletRequest request, MdxQueryO mdxQueryO2) throws BIReportException {
        String listID = request.getParameter("listId");
        WorklistComponent lc = this.page.getWorklistComponentManager().findListComponent(listID);
        return lc.sort2(request, this.page);
    }

    private String doFilterList(HttpServletRequest request) throws BIReportException {
        String listID = request.getParameter("listId");
        WorklistComponent lc = this.page.getWorklistComponentManager().findListComponent(listID);
        return lc.filterList(request, this.page);
    }

    private String getColumnValues(HttpServletRequest request) throws BIReportException {
        String listID = request.getParameter("listId");
        WorklistComponent lc = this.page.getWorklistComponentManager().findListComponent(listID);
        return lc.getColumnValues(request, this.page, true);
    }

    private String doCloseList(HttpServletRequest request, MdxQueryO mdxQueryO2) throws BIReportException {
        String listID = request.getParameter("listId");
        WorklistComponent lc = this.page.getWorklistComponentManager().findListComponent(listID);
        lc.close(request);
        this.page.getWorklistComponentManager().remove(listID);
        return new JSONString("").toString();
    }

    @Override
    public void release() {
        super.release();
        this.component = null;
        this.mdxQueryO = null;
        this.wrc = null;
    }

    public MdxQueryO getCurrentMdxQueryO() {
        return this.mdxQueryO;
    }

    private static class FontFamily {
        public static final String FONT_FAMILY_NAME = "fontFamily";
        private HashMap map = new HashMap(3);

        private FontFamily() {
            this.map.put("Song", "\u5b8b\u4f53");
            this.map.put("Hei", "\u9ed1\u4f53");
            this.map.put("Kai", "\u6977\u4f53");
        }

        public String getFamily(String k) {
            return (String)this.map.get(k);
        }
    }

    private static class FontSize {
        public static final String KEYPROPERTY = "fontSize";
        public static final String DEFAULTKEY = "Standard";
        private static HashMap mapSize = new HashMap();
        private static HashMap mapHeight = new HashMap();
        private static boolean inited = false;

        private FontSize() {
        }

        private static void init() {
            if (!inited) {
                mapSize.put(DEFAULTKEY, "12");
                mapSize.put("Bigger", "14");
                mapSize.put("Biggest", "16");
                mapHeight.put(DEFAULTKEY, new Integer(27));
                mapHeight.put("Bigger", new Integer(29));
                mapHeight.put("Biggest", new Integer(31));
                inited = true;
            }
        }

        public static String getValue(String key) {
            FontSize.init();
            if (key == null || !mapSize.containsKey(key)) {
                key = DEFAULTKEY;
            }
            return (String)mapSize.get(key);
        }

        public static Integer getHeight(String key) {
            FontSize.init();
            if (key == null || !mapSize.containsKey(key)) {
                key = DEFAULTKEY;
            }
            return (Integer)mapHeight.get(key);
        }
    }
}

